package com.example.terminalprotocol;

import java.io.UnsupportedEncodingException;

import com.sdses.JniCommonInterface;

import android.R.string;
import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;

public class Bank extends Activity {
	EditText resDataEditText;
	EditText TRDataEditText;
	EditText trDataEditText;
	EditText ARPCEditText;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.bank);
		resDataEditText=(EditText)findViewById(R.id.et_resData);
		TRDataEditText=(EditText)findViewById(R.id.et_TRData);
		trDataEditText=(EditText)findViewById(R.id.et_transData);
		ARPCEditText=(EditText)findViewById(R.id.et_ARPC);
	}
	
	public void btn_readbank(View v)
	{
		
		EditText tagedEditText=(EditText)findViewById(R.id.et_tag);
		String tagStr=tagedEditText.getText().toString();
		byte[] CardInfo = new byte[4096];
		//ICtype 2既支持非接也支持接触
		long res=JniCommonInterface.IccGetCardInfo(2, "", tagStr, CardInfo);
		 if (res != 0)
         {
             Toast.makeText(this, "读取银行卡信息失败，错误代码："+res, 0).show();
             return;
         }	 
		 
		 Toast.makeText(this,"读取银行卡信息成功", 0).show();
		 try {
			resDataEditText.setText(new String(CardInfo,"GBK").trim());
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void btn_ARQC(View v)
	{
		String trDataStr=trDataEditText.getText().toString();
		byte[] ARQC = new byte[4096];
        byte[] trAppData = new byte[4096];
		long res=JniCommonInterface.IccGetARQC(2, trDataStr, "", ARQC, trAppData);
		if(res!=0)
		{
			 Toast.makeText(this, "获取ARQC失败，错误代码："+res, 0).show();
             return;
		}
		Toast.makeText(this, "获取ARQC成功", 0).show();
		 try {
			 String ResARQC=new String(ARQC,"GBK").trim();
			 String RestrAppData=new String(trAppData,"GBK").trim();
			 resDataEditText.append(ResARQC+"\n");
			 resDataEditText.append(RestrAppData);
			 TRDataEditText.setText(RestrAppData);
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	}
	public void btn_ARPC(View v)
	{
		String trData=trDataEditText.getText().toString().trim();
		String trAppData=TRDataEditText.getText().toString().trim();
		String ARPC=ARPCEditText.getText().toString().trim();
		byte[] ScriptResult = new byte[4096];
        byte[] TC = new byte[4096];
		long res =JniCommonInterface.IccARPCExeScript(2, trData, ARPC, trAppData, ScriptResult, TC);
		if(res!=0)
		{
			 Toast.makeText(this, "执行脚本失败，错误代码："+res, 0).show();
             return;
		}
		Toast.makeText(this, "执行脚本成功", 0).show();
		 try {
			 String ResScriptResult=new String(ScriptResult,"GBK").trim();
			 String ResTC=new String(TC,"GBK").trim();
			 resDataEditText.append("ScriptResult："+ResScriptResult+"\n");
			 resDataEditText.append("TC："+ResTC);
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	}
	public void btn_readTXDetails(View v)
	{
		byte[] TxDetail = new byte[4096];
		long res=JniCommonInterface.IccGetTrDetail(2, "", TxDetail);
		if(res!=0)
		{
			 Toast.makeText(this, "读交易明细失败，错误代码："+res, 0).show();
             return;
		}
		Toast.makeText(this, "读交易明细成功", 0).show();
		 try {
			 resDataEditText.setText(new String(TxDetail,"GBK").trim());
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	}
	public void btn_readDetails(View v)
	{
		byte[] TxDetail = new byte[4096];
		long res=JniCommonInterface.IccGetLoadDetail(2, "", TxDetail);
		if(res!=0)
		{
			 Toast.makeText(this, "读圈存记录失败，错误代码："+res, 0).show();
             return;
		}
		Toast.makeText(this, "读圈存记录成功", 0).show();
		 try {
			 resDataEditText.setText(new String(TxDetail,"GBK").trim());
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	}

}
