﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Diagnostics;

namespace UserDemo
{
    public partial class FormFileList : Form
    {
        public FormFileList()
        {
            InitializeComponent();
        }

        private void FormFileList_Load(object sender, EventArgs e)
        {
            DataTable dt = new DataTable();
            dt.Columns.Add("文件名称");
            dt.Columns.Add("文件版本");
            dt.Columns.Add("产品版本");
            dt.Columns.Add("文件说明");
            dt.Columns.Add("产品名称");
            dt.Columns.Add("文件大小");
            dt.Columns.Add("修改日期");

            DirectoryInfo TheFolder = new DirectoryInfo(AppDomain.CurrentDomain.BaseDirectory);

            //遍历文件
            foreach (FileInfo NextFile in TheFolder.GetFiles())
            {
                if (NextFile.Name.Substring(NextFile.Name.Length - 4) == ".dll")
                {
                    string FileName = NextFile.Name;
                    string FileVersion = FileVersionInfo.GetVersionInfo(NextFile.FullName).FileVersion;
                    string ProductVersion = FileVersionInfo.GetVersionInfo(NextFile.FullName).ProductVersion;
                    string FileDescription = FileVersionInfo.GetVersionInfo(NextFile.FullName).FileDescription;
                    string ProductName = FileVersionInfo.GetVersionInfo(NextFile.FullName).ProductName;
                    string Length = NextFile.Length.ToString();
                    string LastWriteTime = NextFile.LastWriteTime.ToString();
                    dt.Rows.Add(FileName, FileVersion, ProductVersion, FileDescription, ProductName, Length, LastWriteTime);
                }
            }

            dataGridView1.DataSource = dt;
        }
    }
}
