﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Runtime.InteropServices;
using System.Diagnostics;

namespace UserDemo
{
    public partial class FormMain : Form
    {
        Dictionary<int, string> DeviceListMap = new Dictionary<int,string>();

        public FormMain()
        {
            InitializeComponent();
        }

        DataTable dt = new DataTable();

        private void FormMain_Load(object sender, EventArgs e)
        {
            //toolStripStatusLabel2.Text = FileVersionInfo.GetVersionInfo("CommonInterface.dll").FileVersion;
            StringBuilder version = new StringBuilder(1024);
            StringBuilder description = new StringBuilder(1024);
            CommonInterface.GetLibraryInfo(version, description);
            toolStripStatusLabel2.Text = version.ToString();
            dt.Columns.Add("设备端口参数信息");
            dt.Columns.Add("设备句柄");
            dataGridView1.DataSource = dt;
            dataGridView1.Columns[0].Width = 200;
        }

        private void 打开设备ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FormOpenDevPara f = new FormOpenDevPara();
            DialogResult result = f.ShowDialog();
            if (result != System.Windows.Forms.DialogResult.OK)
            {
                StatusLabel.Text = "已取消设备连接";
                return;
            }

            int handle = CommonInterface.OpenDevice(CommonInterface.PortType, CommonInterface.PortPara, CommonInterface.ExtendPara);
            if (handle <= 0)
            {
                StatusLabel.Text = "打开设备失败，错误代码：" + handle.ToString();
                return;
            }

            //int ret = CommonInterface.TerminalHeartBeat();
            //if (ret != 0)
            //{
            //    CommonInterface.CloseDevice();
            //    StatusLabel.Text = "设备心跳失败，错误代码：" + ret.ToString();
            //    return;
            //}

            StatusLabel.Text = "打开设备成功，设备句柄：" + handle.ToString();

            tabControl1.Visible = true;

            StringBuilder version = new StringBuilder(1024);
            StringBuilder description = new StringBuilder(1024);
            CommonInterface.GetLibraryInfo(version, description);
            toolStripStatusLabel2.Text = version.ToString();

            if (DeviceListMap.ContainsKey(handle))
            {
                return;
            }

            DeviceListMap.Add(handle, CommonInterface.PortType + " , " + CommonInterface.PortPara + " , " + CommonInterface.ExtendPara);

            dt.Rows.Clear();
            foreach (KeyValuePair<int, string> key_pair in DeviceListMap)
            {
                dt.Rows.Add(key_pair.Value, key_pair.Key);
            }
        }

        private void ClearIdCardInfo()
        {
            textBoxName.Text = "";
            textBoxGender.Text = "";
            textBoxNation.Text = "";
            textBoxBirth.Text = "";
            textBoxAddress.Text = "";
            textBoxIdNum.Text = "";
            textBoxSignOrg.Text = "";
            textBoxValid.Text = "";
            textBoxMore.Text = "";
            pictureBox1.Image = null;

            Application.DoEvents();
        }

        byte IdCardType = 0x00;

        private void button1_Click(object sender, EventArgs e)
        {
            ClearIdCardInfo();

            StringBuilder IdCardInfo = new StringBuilder(409600);
            int ret = CommonInterface.IdReadCard(IdCardType, 1, IdCardInfo, 0);
            if (ret != 0)
            {
                StatusLabel.Text = "读取证件信息失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "读取证件信息成功";

            string[] CardInfo = IdCardInfo.ToString().Split(':');

            textBoxName.Text = CardInfo[1];
            textBoxGender.Text = CardInfo[3];
            textBoxNation.Text = CardInfo[5];
            textBoxBirth.Text = CardInfo[7];
            textBoxAddress.Text = CardInfo[8];
            textBoxIdNum.Text = CardInfo[9];
            textBoxSignOrg.Text = CardInfo[10];
            textBoxValid.Text = CardInfo[11] + " - " + CardInfo[12];
            string MoreInfo = "证件类型标识：" + CardInfo[0];
            switch (CardInfo[0])
            {
                case "I":
                    {
                        MoreInfo += "  英文姓名：" + CardInfo[2] + "  证件版本号：" + CardInfo[13];
                        break;
                    }
                case "J":
                    {
                        MoreInfo += "  通行证号码：" + CardInfo[6] + "  签发次数：" + CardInfo[13];
                        break;
                    }
            }            

            textBoxMore.Text = MoreInfo;

            byte[] Photo = Convert.FromBase64String(CardInfo[14]);
            MemoryStream ms = new MemoryStream(Photo);
            pictureBox1.Image = Image.FromStream(ms);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            byte[] UID = new byte[16];
            int UIDLen = 0;
            int ret = CommonInterface.M1FindCard(UID, ref UIDLen);
            if (ret != 0)
            {
                StatusLabel.Text = "M1卡寻卡失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "M1卡寻卡成功";

            StringBuilder UIDStr = new StringBuilder(32);
            CommonInterface.HexToAsc(UID, UIDLen, UIDStr);

            textBoxUID.Text = UIDStr.ToString();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            byte KeyType = (byte)comboBoxKeyType.Text[0];
            byte SecAddr = byte.Parse(textBoxSecAddr.Text);
            byte[] Key = new byte[16];
            byte[] UID = new byte[16];
            if(textBoxKey.Text.Length != 12)
            {
                StatusLabel.Text = "M1卡密钥长度错误，应为12个HEX字符（6个字节）";
                return;
            }
            CommonInterface.AscToHex(textBoxKey.Text, 6, Key);
            CommonInterface.AscToHex(textBoxUID.Text, 4, UID);

            int ret = CommonInterface.M1Authentication(KeyType, SecAddr, Key, UID);
            if (ret != 0)
            {
                StatusLabel.Text = "M1卡密钥认证失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "M1卡密钥认证成功";
        }

        private void button4_Click(object sender, EventArgs e)
        {
            byte BlockAddr = byte.Parse(textBoxBlockAddr.Text);
            byte[] BlockData = new byte[32];
            int BlockDataLen = 0;
            int ret = CommonInterface.M1ReadBlock(BlockAddr, BlockData, ref BlockDataLen);
            if (ret != 0)
            {
                StatusLabel.Text = "M1卡读块数据失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "M1卡读块数据成功";

            StringBuilder BlockDataStr = new StringBuilder(64);
            CommonInterface.HexToAsc(BlockData, BlockDataLen, BlockDataStr);
            textBoxRBlockData.Text = BlockDataStr.ToString();
        }

        private void button5_Click(object sender, EventArgs e)
        {
            byte BlockAddr = byte.Parse(textBoxBlockAddr.Text);
            byte[] BlockData = new byte[32];
            if (textBoxWBlockData.Text.Length != 32)
            {
                StatusLabel.Text = "M1卡写块数据长度错误，应为32个HEX字符（16个字节）";
                return;
            }
            CommonInterface.AscToHex(textBoxWBlockData.Text, 16, BlockData);
            int ret = CommonInterface.M1WriteBlock(BlockAddr, 16, BlockData);
            if (ret != 0)
            {
                StatusLabel.Text = "M1卡写块数据失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "M1卡写块数据成功";
        }

        private void button6_Click(object sender, EventArgs e)
        {
            byte[] Slot = new byte[16];
            CommonInterface.AscToHex(comboBoxSlot.Text, 1, Slot);
            byte[] ATRS = new byte[128];
            int ATRSLen = 0;
            int ret = CommonInterface.CpuPowerOn(Slot[0], ATRS, ref ATRSLen);
            if (ret != 0)
            {
                StatusLabel.Text = "CPU卡上电失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "CPU卡上电成功";

            StringBuilder ATRSStr = new StringBuilder(256);
            CommonInterface.HexToAsc(ATRS, ATRSLen, ATRSStr);

            textBoxATRS.Text = ATRSStr.ToString();
        }

        private void button8_Click(object sender, EventArgs e)
        {
            byte[] Slot = new byte[16];
            byte[] SendApdu = new byte[1024];
            int SendApduLen = comboBoxSendApdu.Text.Length;
            if (SendApduLen % 2 != 0)
            {
                StatusLabel.Text = "发送APDU的数据应为偶数个HEX字符";
                return;
            }
            SendApduLen = SendApduLen/2;

            CommonInterface.AscToHex(comboBoxSendApdu.Text, SendApduLen, SendApdu);           
            CommonInterface.AscToHex(comboBoxSlot.Text, 1, Slot);

            byte[] RecvApdu = new byte[1024];
            int RecvApduLen = 0;
            int ret = CommonInterface.CpuApdu(Slot[0], SendApduLen, SendApdu, RecvApdu, ref RecvApduLen);
            if (ret != 0)
            {
                StatusLabel.Text = "CPU卡发送APDU失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "CPU卡发送APDU成功";

            StringBuilder RecvApduStr = new StringBuilder(2048);
            CommonInterface.HexToAsc(RecvApdu, RecvApduLen, RecvApduStr);

            textBoxRecvApdu.Text = RecvApduStr.ToString();
        }

        private void button7_Click(object sender, EventArgs e)
        {
            byte[] Slot = new byte[16];
            CommonInterface.AscToHex(comboBoxSlot.Text, 1, Slot);

            int ret = CommonInterface.CpuPowerOff(Slot[0]);
            if (ret != 0)
            {
                StatusLabel.Text = "CPU卡下电失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "CPU卡下电成功";
        }

        private void 关闭设备ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            int Handle = CommonInterface.GetCurrentDevice();

            int ret = CommonInterface.CloseDevice();
            if (ret != 0)
            {
                StatusLabel.Text = "关闭设备失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "关闭设备成功";

            DeviceListMap.Remove(Handle);

            if (DeviceListMap.Count == 0)
            {
                tabControl1.Visible = false;
            }        

            dt.Rows.Clear();
            foreach (KeyValuePair<int, string> key_pair in DeviceListMap)
            {
                dt.Rows.Add(key_pair.Value, key_pair.Key);
            }
        }

        private void button18_Click(object sender, EventArgs e)
        {
            int ret = CommonInterface.GetCurrentDevice();
            if (ret <= 0)
            {
                StatusLabel.Text = "获取当前设备句柄失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "当前操作的设备句柄为：" + ret.ToString();
        }
        
        private void button17_Click(object sender, EventArgs e)
        {
            int Handle = int.Parse(textBoxDeviceHandle.Text);
            int ret = CommonInterface.SetCurrentDevice(Handle);
            if (ret != 0)
            {
                StatusLabel.Text = "设置当前设备句柄失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "已将当前操作的设备设置为：" + Handle.ToString();
        }

        private void button9_Click(object sender, EventArgs e)
        {
            StringBuilder SSCardInfo = new StringBuilder(4096);
            StringBuilder ErrorInfo = new StringBuilder(1024);
            int ret = CommonInterface.SsseReadCard(3, SSCardInfo, ErrorInfo);
            if (ret != 0)
            {
                StatusLabel.Text = "读取社保卡信息失败，错误代码：" + ret.ToString() + "  " + ErrorInfo.ToString();
                return;
            }

            StatusLabel.Text = "读取社保卡信息成功";

            string[] CardInfo = SSCardInfo.ToString().Split(':');

            textBoxSsseCardNumber.Text = CardInfo[6];
            textBoxSsseCategory.Text = CardInfo[1];
            textBoxSsseStandardVersion.Text = CardInfo[2];
            textBoxSsseBegin.Text = CardInfo[4];
            textBoxSsseValid.Text = CardInfo[5];
            textBoxSsseInitOrg.Text = CardInfo[3];
            textBoxSsseIdentityNumber.Text = CardInfo[0];
            textBoxSsseIdNumber.Text = CardInfo[7];
            textBoxSsseName.Text = CardInfo[8];
            textBoxSsseGender.Text = CardInfo[10];
            textBoxSsseNation.Text = CardInfo[11];
            textBoxSsseBirthPlace.Text = CardInfo[12];
            textBoxSsseBirthDate.Text = CardInfo[13];
        }

        private void 查看详细信息ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            StatusLabel.Text = "";
        }

        private void button10_Click(object sender, EventArgs e)
        {
            StringBuilder CardInfo = new StringBuilder(4096);
            int ret = CommonInterface.IccGetCardInfo(2, "", textBoxTagList.Text, CardInfo);
            if (ret != 0)
            {
                StatusLabel.Text = "读取银行卡信息失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "读取银行卡信息成功";

            textBoxIccInfo.Text = CardInfo.ToString();
        }

        private void button11_Click(object sender, EventArgs e)
        {
            StringBuilder ARQC = new StringBuilder(4096);
            StringBuilder trAppData = new StringBuilder(4096);
            int ret = CommonInterface.IccGetARQC(2, textBoxARQCData.Text, "", ARQC, trAppData);
            if (ret != 0)
            {
                StatusLabel.Text = "获取ARQC失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "获取ARQC成功";

            textBoxIccInfo.Text = "ARQC：" + ARQC.ToString() + "\r\ntrAppData：" + trAppData.ToString();
            textBoxTrAppData.Text = trAppData.ToString();
        }

        private void button12_Click(object sender, EventArgs e)
        {
            StringBuilder ScriptResult = new StringBuilder(4096);
            StringBuilder TC = new StringBuilder(4096);
            int ret = CommonInterface.IccARPCExeScript(2, textBoxARQCData.Text, textBoxARPC.Text, textBoxTrAppData.Text, ScriptResult, TC);
            if (ret != 0)
            {
                StatusLabel.Text = "执行脚本失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "执行脚本成功";

            textBoxIccInfo.Text = "ScriptResult：" + ScriptResult.ToString() + "\r\nTC：" + TC.ToString();
        }

        private void button15_Click(object sender, EventArgs e)
        {
            StringBuilder TxDetail = new StringBuilder(4096);
            int ret = CommonInterface.IccGetTrDetail(2, "", TxDetail);
            if (ret != 0)
            {
                StatusLabel.Text = "读交易明细失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "读交易明细成功";

            textBoxIccInfo.Text = "TxDetail：" + TxDetail.ToString();
        }

        private void button16_Click(object sender, EventArgs e)
        {
            StringBuilder TxDetail = new StringBuilder(4096);
            int ret = CommonInterface.IccGetLoadDetail(2, "", TxDetail);
            if (ret != 0)
            {
                StatusLabel.Text = "读圈存记录失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "读圈存记录成功";

            textBoxIccInfo.Text = "TxDetail：" + TxDetail.ToString();
        }

        private void 查看接口明细ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FormFileList flst = new FormFileList();
            flst.ShowDialog();
        }

        private void button19_Click(object sender, EventArgs e)
        {
            StringBuilder SamId = new StringBuilder(256);
            int ret = CommonInterface.SamGetIdStr(SamId);
            if (ret != 0)
            {
                StatusLabel.Text = "读取SAM模块号失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "读取SAM模块号成功";

            textBoxTestInfo.Text = SamId.ToString();
        }

        private void button26_Click(object sender, EventArgs e)
        {
            StringBuilder SamId = new StringBuilder(256);
            int ret = CommonInterface.SdtSamGetIdStr(SamId);
            if (ret != 0)
            {
                StatusLabel.Text = "读取SAM模块号失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "读取SAM模块号成功";

            textBoxTestInfo.Text = SamId.ToString();
        }

        private void button20_Click(object sender, EventArgs e)
        {
            StringBuilder Model = new StringBuilder(256);
            int ret = CommonInterface.TerminalGetModel(Model);
            if (ret != 0)
            {
                StatusLabel.Text = "读取设备型号失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "读取设备型号成功";

            textBoxTestInfo.Text = Model.ToString();
        }

        private void button21_Click(object sender, EventArgs e)
        {
            int ret = CommonInterface.TerminalHeartBeat();
            if (ret != 0)
            {
                StatusLabel.Text = "设备连接状态异常，错误代码：" + ret.ToString();
                textBoxTestInfo.Text = "设备未连接或状态异常";
                return;
            }

            StatusLabel.Text = "设备连接状态正常";

            textBoxTestInfo.Text = "设备连接状态正常";
        }

        private void button22_Click(object sender, EventArgs e)
        {
            ClearIdCardInfo();

            StringBuilder IdCardInfo = new StringBuilder(409600);
            int ret = CommonInterface.SdtReadCard(IdCardType, 1, IdCardInfo, 0);
            if (ret != 0)
            {
                StatusLabel.Text = "读取证件信息失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "读取证件信息成功";

            string[] CardInfo = IdCardInfo.ToString().Split(':');

            textBoxName.Text = CardInfo[1];
            textBoxGender.Text = CardInfo[3];
            textBoxNation.Text = CardInfo[5];
            textBoxBirth.Text = CardInfo[7];
            textBoxAddress.Text = CardInfo[8];
            textBoxIdNum.Text = CardInfo[9];
            textBoxSignOrg.Text = CardInfo[10];
            textBoxValid.Text = CardInfo[11] + " - " + CardInfo[12];
            string MoreInfo = "证件类型标识：" + CardInfo[0];
            switch (CardInfo[0])
            {
                case "I":
                    {
                        MoreInfo += "  英文姓名：" + CardInfo[2] + "  证件版本号：" + CardInfo[13];
                        break;
                    }
                case "J":
                    {
                        MoreInfo += "  通行证号码：" + CardInfo[6] + "  签发次数：" + CardInfo[13];
                        break;
                    }
            }

            textBoxMore.Text = MoreInfo;

            byte[] Photo = Convert.FromBase64String(CardInfo[14]);
            MemoryStream ms = new MemoryStream(Photo);
            pictureBox1.Image = Image.FromStream(ms);
        }

        private void button23_Click(object sender, EventArgs e)
        {
            byte[] SN = new byte[16];
            int SNLen = 0;
            int ret = CommonInterface.IdReadSn(SN, ref SNLen);
            if (ret != 0)
            {
                StatusLabel.Text = "读二代证卡体管理号SN失败，错误代码：" + ret.ToString();
                return;
            }

            StringBuilder SnStr = new StringBuilder(16);
            CommonInterface.HexToAsc(SN, SNLen, SnStr);

            StatusLabel.Text = "读二代证卡体管理号SN成功：" + SnStr.ToString();
        }

        private void button13_Click(object sender, EventArgs e)
        {
            StringBuilder track1 = new StringBuilder(512);
            StringBuilder track2 = new StringBuilder(512);
            StringBuilder track3 = new StringBuilder(512);
            int ret = CommonInterface.MagRead(byte.Parse(comboBoxMagTracks.Text), track1, track2, track3, byte.Parse(textBoxMagTimeOut.Text));
            if (ret != 0)
            {
                StatusLabel.Text = "读取磁条卡失败，错误代码：" + ret.ToString();
                return;
            }

            textBoxMagTrack1.Text = track1.ToString();
            textBoxMagTrack2.Text = track2.ToString();
            textBoxMagTrack3.Text = track3.ToString();

            StatusLabel.Text = "读取磁条卡成功";
        }

        private void button14_Click(object sender, EventArgs e)
        {
            int ret = CommonInterface.MagWrite(byte.Parse(comboBoxMagTracks.Text), textBoxMagTrack1.Text, textBoxMagTrack2.Text, textBoxMagTrack3.Text, byte.Parse(textBoxMagTimeOut.Text));
            if (ret != 0)
            {
                StatusLabel.Text = "写入磁条卡失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "写入磁条卡成功";
        }

        private void button24_Click(object sender, EventArgs e)
        {
            int ret = CommonInterface.SamGetStatus();
            if (ret != 0)
            {
                StatusLabel.Text = "获取SAM模块状态失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "获取SAM模块状态成功";

            textBoxTestInfo.Text = "SAM模块状态正常";
        }

        private void button25_Click(object sender, EventArgs e)
        {
            int ret = CommonInterface.SdtSamGetStatus();
            if (ret != 0)
            {
                StatusLabel.Text = "获取SAM模块状态失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "获取SAM模块状态成功";

            textBoxTestInfo.Text = "SAM模块状态正常";
        }

        private void button27_Click(object sender, EventArgs e)
        {
            StringBuilder QrData = new StringBuilder(512);
            int ret = CommonInterface.QrRead(QrData, byte.Parse(textBoxQrTimeOut.Text));
            if (ret != 0)
            {
                StatusLabel.Text = "读取二维码失败，错误代码：" + ret.ToString();
                return;
            }

            textBoxQrData.Text = QrData.ToString();

            StatusLabel.Text = "读取二维码成功";            
        }

        private void button28_Click(object sender, EventArgs e)
        {
            StringBuilder FirmVersion = new StringBuilder(256);
            StringBuilder HardwareVersion = new StringBuilder(256);
            int ret = CommonInterface.TerminalGetFirmVersion(FirmVersion, HardwareVersion);
            if (ret != 0)
            {
                StatusLabel.Text = "读取固件版本号失败，错误代码：" + ret.ToString();
                return;
            }

            StatusLabel.Text = "读取固件版本号成功";

            textBoxTestInfo.Text = "固件版本：" + FirmVersion.ToString() + "\r\n硬件版本：" + HardwareVersion.ToString();
        }

        private void 设置协议ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenFileDialog dlg = new OpenFileDialog();
            dlg.Filter = "协议层动态库|TerminalProtocol*.dll|动态链接库|*.dll|所有文件|*.*";

            if (dlg.ShowDialog() != System.Windows.Forms.DialogResult.OK)
            {
                StatusLabel.Text = "已取消设置协议层动态库";
                return;
            }

            int ret = CommonInterface.SetTerminalLibrary(dlg.SafeFileName);
            if (ret != 0)
            {
                StatusLabel.Text = "设置协议层动态库失败：" + ret;
                return;
            }

            StatusLabel.Text = "设置协议层动态库成功";
        }

        private void button29_Click(object sender, EventArgs e)
        {
            StringBuilder SSCardInfo = new StringBuilder(4096);
            StringBuilder ErrorInfo = new StringBuilder(1024);
            int ret = CommonInterface.SsseReadCard2(3, SSCardInfo, ErrorInfo);
            if (ret != 0)
            {
                StatusLabel.Text = "读取社保卡信息失败，错误代码：" + ret.ToString() + "  " + ErrorInfo.ToString();
                return;
            }

            StatusLabel.Text = "读取社保卡信息成功";

            string[] CardInfo = SSCardInfo.ToString().Split(':');

            textBoxSsseCardNumber.Text = CardInfo[6];
            textBoxSsseCategory.Text = CardInfo[1];
            textBoxSsseStandardVersion.Text = CardInfo[2];
            textBoxSsseBegin.Text = CardInfo[4];
            textBoxSsseValid.Text = CardInfo[5];
            textBoxSsseInitOrg.Text = CardInfo[3];
            textBoxSsseIdentityNumber.Text = CardInfo[0];
            textBoxSsseIdNumber.Text = CardInfo[7];
            textBoxSsseName.Text = CardInfo[8];
            textBoxSsseGender.Text = CardInfo[10];
            textBoxSsseNation.Text = CardInfo[11];
            textBoxSsseBirthPlace.Text = CardInfo[12];
            textBoxSsseBirthDate.Text = CardInfo[13];
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {
                IdCardType = 0x10;
            }
            else
            {
                IdCardType = 0x00;
            }
        }     
    }
}
