﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;

namespace UserDemo
{
    public partial class FormOpenDevPara : Form
    {
        public FormOpenDevPara()
        {
            InitializeComponent();
        }

        private void FormOpenDevPara_Load(object sender, EventArgs e)
        {
            
        }

        private void radioButton1_Click(object sender, EventArgs e)
        {
            textBox1.Enabled = true;
            textBox2.Enabled = true;
            textBox3.Enabled = true;
            comboBoxDevInfo.Visible = false;

            string[] ComPort = SerialPort.GetPortNames();
            if (ComPort.Length != 0)
            {
                textBox1.Text = ComPort[0];
            }
            else
            {
                textBox1.Text = "1";
            }
            textBox2.Text = "115200";
            textBox3.Text = "";

            label5.Text = "（串口号）";
            label6.Text = "（波特率）";
            label7.Text = "（扩展盒）";
        }

        private void radioButton2_Click(object sender, EventArgs e)
        {
            textBox1.Enabled = true;
            textBox2.Enabled = true;
            textBox3.Enabled = true;
            comboBoxDevInfo.Visible = true;

            textBox1.Text = "USB";
            textBox2.Text = "261A0011";
            textBox3.Text = "";

            label5.Text = "（USB）";
            label6.Text = "（VID_PID）";
            label7.Text = "（传输方式）";

            comboBoxDevInfo.SelectedIndex = 3;
        }      

        private void radioButton3_Click(object sender, EventArgs e)
        {
            textBox1.Enabled = false;
            textBox2.Enabled = true;
            textBox3.Enabled = false;
            comboBoxDevInfo.Visible = false;

            textBox1.Text = "BTH";
            textBox2.Text = "SS";
            textBox3.Text = "";

            label5.Text = "（BTH）";
            label6.Text = "（蓝牙名称）";
            label7.Text = "（无）";
        }

        private void radioButton4_Click(object sender, EventArgs e)
        {
            textBox1.Enabled = false;
            textBox2.Enabled = true;
            textBox3.Enabled = false;
            comboBoxDevInfo.Visible = false;

            textBox1.Text = "SKT";
            textBox2.Text = "127.0.0.1:8888";
            textBox3.Text = "";

            label5.Text = "（SKT）";
            label6.Text = "（IP:端口）";
            label7.Text = "（无）";
        }

        private void button1_Click(object sender, EventArgs e)
        {
            CommonInterface.PortType = textBox1.Text;
            CommonInterface.PortPara = textBox2.Text;
            CommonInterface.ExtendPara = textBox3.Text;
            this.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.Close();
        }

        private void comboBoxDevInfo_SelectedIndexChanged(object sender, EventArgs e)
        {
            textBox2.Text = comboBoxDevInfo.Text.Substring(0, 8);
            if (textBox2.Text == "261A000C")
            {
                textBox3.Text = "MC";
            }
            else
            {
                textBox3.Text = "";
            }
        }

        private void radioButton5_Click(object sender, EventArgs e)
        {
            textBox1.Enabled = true;
            textBox2.Enabled = false;
            textBox3.Enabled = false;
            comboBoxDevInfo.Visible = false;

            textBox1.Text = "AUTO";
            textBox2.Text = "";
            textBox3.Text = "";
            label5.Text = "（AUTO）";
            label6.Text = "（无）";
            label7.Text = "（无）";
        }
    }
}
