#include <stdio.h>
#include <dlfcn.h>
#include <unistd.h>
#include <string.h>
#include <iconv.h>
//#include "CommonInterface.h"

typedef long (*_OpenDevice)(char *PortType, char *PortPara, char *ExtendPara);
typedef long (*_IdReadCard)(unsigned char Type, unsigned char InfoEncoding, char *IdCardInfo, long TimeOutMs);
typedef long (*_SdtReadCard)(unsigned char Type, unsigned char InfoEncoding, char *IdCardInfo, long TimeOutMs);
typedef long (*_CloseDevice)();
typedef long (*_IccGetCardInfo)(int ICtype, char *AIDList, char *TagList, char *IcCardInfo);
_OpenDevice pOpenDevice = NULL;
_IdReadCard pIdReadCard = NULL;
_SdtReadCard pSdtReadCard = NULL;
_CloseDevice pCloseDevice = NULL;
_IccGetCardInfo pIccGetCardInfo = NULL;

bool GBKToUTF8(char *GBK, int ConvertLen, char *UTF8)
{
	if (UTF8 == NULL || GBK == NULL)
	{
		return false;
	}

	iconv_t hconv = iconv_open("UTF-8", "GBK");
	if(hconv == NULL)
	{
		return false;
	}

	char *in = GBK;
	char *out = UTF8;
	size_t inlen = ConvertLen;
    size_t outlen = 3*ConvertLen;
	int ret = iconv(hconv, &in, &inlen, &out, &outlen);
	iconv_close(hconv);
	if(ret != 0)
	{
		return false;
	}

	return true;
}

int main()
{
	char CurrentPath[1024] = {0};
	getcwd(CurrentPath, 1024);
	char DllPath[1024] = {0};
	sprintf(DllPath, "%s%s", CurrentPath, "/libCommonInterface.so");
	void *hDll = dlopen(DllPath, RTLD_LAZY);
	if(hDll == NULL)
	{
		printf("hDll = NULL\n");
		return 0;
	}
	pOpenDevice = (_OpenDevice)dlsym(hDll, "OpenDevice");
	pIdReadCard = (_IdReadCard)dlsym(hDll, "IdReadCard");
	pSdtReadCard = (_SdtReadCard)dlsym(hDll, "SdtReadCard");
	pCloseDevice = (_CloseDevice)dlsym(hDll, "CloseDevice");
	pIccGetCardInfo = (_IccGetCardInfo)dlsym(hDll, "IccGetCardInfo");
	if(pOpenDevice == NULL || pIdReadCard == NULL || pCloseDevice == NULL)
	{
		printf("Function = NULL\n");
		return 0;
	}

	char input_temp[10240] = {0};
	while(1)
	{
		printf("**************************************\n");
		printf("           【1】连接读卡器            \n");
		printf("           【2】读取身份证            \n");
		printf("           【3】断开读卡器            \n");
		printf("           【4】退出此程序            \n");
		printf("**************************************\n");
		printf("请输入要进行的操作：                  \n");
		
		int fun = 0;
		scanf("%d", &fun);
		switch(fun)
		{
			case 1:
			{
				long handle = -1;
				
				printf("是否使用AUTO参数自动连接？y/n\n");
				char Input[1024] = {0};
				scanf("%s", Input);				
				if(Input[0] == 'Y' || Input[0] == 'y')
				{
					handle = pOpenDevice((char*)"AUTO", (char*)"", (char*)"");
				}
				else
				{
					printf("请输入要连接的读卡器端口类型：（示例：USB，COM/dev/ttyS3）\n");
		
					char PortType[1024] = {0};
					scanf("%s", PortType);
					
					printf("请输入要连接的读卡器端口参数：（示例：0400C35A，261A0011，115200）\n");
					char PortPara[1024] = {0};
					scanf("%s", PortPara);
					
					printf("请输入要连接的读卡器扩展参数：（示例：MC，MI，1B2541）\n");
					char ExtendPara[1024] = {0};
					scanf("%s", ExtendPara);
			
					handle = pOpenDevice(PortType, PortPara, ExtendPara);
				}
				
				if(handle < 0)
				{
					printf("连接读卡器失败：%ld\n", handle);
					continue;
				}	
							
				printf("连接读卡器成功\n");
				
				printf("\n按回车键继续……\n");getchar();getchar();
				break;
			}
			case 2:
			{
				char IdCardInfo[102400] = {0};
				long ret = pIdReadCard(0, 3, IdCardInfo, 0);
				if(ret != 0)
				{
					printf("读取身份证失败：%ld\n", ret);
					continue;
				}
					
				printf("%s\n", IdCardInfo);
				
				printf("\n读取身份证成功\n");
				printf("\n按回车键继续……\n");getchar();getchar();
				break;
			}
			case 3:
			{
				long ret = pCloseDevice();
				if(ret != 0)
				{
					printf("关闭读卡器失败：%ld\n", ret);
					continue;
				}
				
				printf("关闭读卡器成功\n");
				printf("\n按回车键继续……\n");getchar();getchar();
				break;
			}
			case 4:
			{
				return 0;
				break;
			}
			default:
			{
				printf("您的输入有误！\n");				
				scanf("\n%[^\n]", input_temp);
				break;
			}
		}
	}
}
