#include "dialog.h"
#include "ui_dialog.h"

Dialog::Dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)
{
    ui->setupUi(this);
    Result = -1;
}

Dialog::~Dialog()
{
    delete ui;
}

void Dialog::on_radioButton_com_clicked()
{
    ui->lineEdit_PortType->setText("COM/dev/ttyS3");
    ui->lineEdit_PortPara->setText("115200");
    ui->lineEdit_ExtendPara->setText("");

    ui->label_PortType->setText("（串口号）");
    ui->label_PortPara->setText("（波特率）");
    ui->label_ExtendPara->setText("（扩展盒）");
}

void Dialog::on_radioButton_usb_clicked()
{
    ui->lineEdit_PortType->setText("USB");
    ui->lineEdit_PortPara->setText("261A0011");
    ui->lineEdit_ExtendPara->setText("");

    ui->label_PortType->setText("（USB）");
    ui->label_PortPara->setText("（VID_PID）");
    ui->label_ExtendPara->setText("（传输方式）");
}

void Dialog::on_radioButton_bth_clicked()
{
    ui->lineEdit_PortType->setText("BTH");
    ui->lineEdit_PortPara->setText("SS");
    ui->lineEdit_ExtendPara->setText("");

    ui->label_PortType->setText("（BTH）");
    ui->label_PortPara->setText("（蓝牙名称）");
    ui->label_ExtendPara->setText("（无）");
}

void Dialog::on_radioButton_skt_clicked()
{
    ui->lineEdit_PortType->setText("SKT");
    ui->lineEdit_PortPara->setText("127.0.0.1:8888");
    ui->lineEdit_ExtendPara->setText("");

    ui->label_PortType->setText("（SKT）");
    ui->label_PortPara->setText("（IP:端口）");
    ui->label_ExtendPara->setText("（无）");
}

void Dialog::on_pushButton_clicked()
{
    PortType = ui->lineEdit_PortType->text();
    PortPara = ui->lineEdit_PortPara->text();
    ExtendPara = ui->lineEdit_ExtendPara->text();

    Result = 0;

    this->close();
}
