/*
 * Decompiled with CFR 0.152.
 */
package com.sdses.id2CardInterface;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.util.Log;
import com.hisign.AS60xSDK.AS60xIO;
import com.sdses.JniCommonInterface;
import com.sdses.bean.ID2Data;
import com.sdses.bean.ID2FP;
import com.sdses.fingerJar.Files;
import com.sdses.fingerJar.SsFinger;
import com.sdses.fingerJar.Util;
import com.sdses.manage.ManageReadIDCard;
import com.sdses.tool.SSUtil;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class ID2CardInterface {
    public static final String GPIO_PATH = "/sys/bus/platform/drivers/gpioctrl_sdses/gpioctrl/gpioctrl_sdses";
    public static final String M20D_PARA_ID2_POWERON = "1";
    public static final String M20D_PARA_ID2_POWEROFF = "g";
    public static final String PARA_ID2_POWERON = "3";
    public static final String PARA_ID2_POWEROFF = "2";
    public static final String PARA_FP_POWERON = "1";
    public static final String PARA_FP_POWEROFF = "0";
    public static final String M20AT_GPIO_PATH = "/sys/bus/platform/drivers/gpioctrl_sdses/GpioCtrl_sdses/gpioctrl_sdses";
    public static final String M20AT_PARA_ID2_POWER_ON = "2";
    public static final String M20AT_PARA_ID2_POWEROFF = "h";
    public static final String M20AT_PARA_FP_POWER_ON = "3";
    public static final String M20AT_PARA_FP_POWER_OFF = "i";
    public static final String PARA_ID2_POWER_ON_M20AT = "2";
    public static final String PARA_ID2_POWER_OFF_M20AT = "h";
    public static final String PARA_FP_POWER_ON_M20AT = "3";
    public static final String PARA_FP_POWER_OFF_M20AT = "i";
    ManageReadIDCard mManageReadIDCard;
    public static final String TAG = "id2CardInterface";
    private ID2FP mID2FP = null;
    String[] result = new String[22];
    private static Files ioFile;
    private Context mContext;
    private SsFinger tcf = null;
    private UsbManager manager;
    private UsbDevice mUsbDevice;
    private UsbInterface mInterface;
    private UsbDeviceConnection mDeviceConnection;
    private UsbEndpoint epOut;
    private UsbEndpoint epIn;
    PendingIntent mPermissionIntent;
    private IntentFilter filter = new IntentFilter();
    private static final String ACTION_USB_PERMISSION = "com.android.sdses.USB_PERMISSION";
    ArrayList<String> USBDeviceList = new ArrayList();
    int max = 64;
    byte[] writeBuf = new byte[this.max];
    int length = 0;
    byte[] idTxt = new byte[256];
    byte[] idPic = new byte[1024];
    byte[] idFp = new byte[1024];
    private byte[] mID2AddRAW = new byte[73];
    private boolean isHaveFinger = false;
    private int USB_BUFF_LEN = 4096;
    private int USB_ACKLEN = 64;
    private byte[] receiveBytes = new byte[64];
    private byte[] dataBytes = new byte[this.USB_BUFF_LEN];

    private void initFilter() {
        this.filter.addAction("android.intent.action.UMS_CONNECTED");
        this.filter.addAction("android.intent.action.UMS_DISCONNECTED");
        this.filter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
        this.filter.addAction("android.intent.action.MEDIA_MOUNTED");
        this.filter.addAction("android.intent.action.MEDIA_EJECT");
        this.filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        this.filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        this.filter.addAction("android.hardware.usb.action.USB_ACCESSORY_ATTACHED");
        this.filter.addAction("android.hardware.usb.action.USB_ACCESSORY_DETACHED");
        this.filter.addAction("permission");
        this.filter.addAction("device");
        this.filter.addAction("accessory");
        this.filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        this.filter.addAction("android.hardware.usb.action.USB_ACCESSORY_ATTACHED");
        this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
    }

    public ID2CardInterface(Context context) {
        this.mContext = context;
        this.initFilter();
        this.mManageReadIDCard = new ManageReadIDCard();
        this.mManageReadIDCard.getID2DataController("com.sdses.bean.ID2Data");
        this.mManageReadIDCard.getID2CardReader("com.sdses.common.impl.ReadCardFromSerialport");
    }

    public boolean searchID2Card() {
        return this.mManageReadIDCard.selectID2Card();
    }

    public String[] readCardInfoNew() {
        if (this.mManageReadIDCard.readID2Card()) {
            ((ID2Data)this.mManageReadIDCard.getmID2DataRAW()).rePackage();
            ID2Data _ID2Data = (ID2Data)this.mManageReadIDCard.getmID2DataRAW();
            if (_ID2Data.getmID2Txt().getCardType().equals("id2")) {
                this.returnId2Info(_ID2Data);
            } else if (_ID2Data.getmID2Txt().getCardType().equals("forienger")) {
                this.returnForiengerInfo(_ID2Data);
            } else if (_ID2Data.getmID2Txt().getCardType().equals("gatresidence")) {
                this.returnGatResidenceInfo(_ID2Data);
            }
            return this.result;
        }
        this.result[0] = "-1";
        this.result[1] = "\u8bfb\u5361\u5931\u8d25";
        return this.result;
    }

    private String[] returnId2Info(ID2Data _ID2Data) {
        this.result[0] = PARA_FP_POWEROFF;
        this.result[1] = _ID2Data.getmID2Txt().getmName().trim();
        this.result[2] = _ID2Data.getmID2Txt().getmGender().trim();
        this.result[3] = _ID2Data.getmID2Txt().getmNational().trim();
        this.result[4] = _ID2Data.getmID2Txt().getmBirthYear().trim();
        this.result[5] = _ID2Data.getmID2Txt().getmBirthMonth().trim();
        this.result[6] = _ID2Data.getmID2Txt().getmBirthDay().trim();
        this.result[7] = _ID2Data.getmID2Txt().getmAddress().trim();
        this.result[8] = _ID2Data.getmID2Txt().getmID2Num().trim();
        this.result[9] = _ID2Data.getmID2Txt().getmIssue().trim();
        this.result[10] = _ID2Data.getmID2Txt().getmBegin().trim();
        this.result[11] = _ID2Data.getmID2Txt().getmEnd().trim();
        this.result[12] = SSUtil.toHexStringNoSpace(_ID2Data.getmID2Pic().getHeadFromCard(), _ID2Data.getmID2Pic().getHeadFromCard().length);
        this.result[20] = _ID2Data.getmID2Txt().getCardType();
        this.result[13] = _ID2Data.getmID2NewAddress() != null ? _ID2Data.getmID2NewAddress() : "-1";
        if (_ID2Data.getmID2FP() == null) {
            this.result[14] = "-1";
        } else {
            this.result[14] = PARA_FP_POWEROFF;
            this.result[15] = _ID2Data.getmID2FP().getFingerPosition(1);
            this.result[16] = _ID2Data.getmID2FP().getFingerPosition(2);
            this.result[17] = SSUtil.toHexStringNoSpace(_ID2Data.getmID2FP().getmID2FPOne(), 512);
            this.result[18] = SSUtil.toHexStringNoSpace(_ID2Data.getmID2FP().getmID2FPTwo(), 512);
        }
        return this.result;
    }

    private String[] returnGatResidenceInfo(ID2Data _ID2Data) {
        this.result[0] = PARA_FP_POWEROFF;
        this.result[1] = _ID2Data.getmID2Txt().getgatName().trim();
        this.result[2] = _ID2Data.getmID2Txt().getgatGender().trim();
        this.result[3] = _ID2Data.getmID2Txt().getgatPassPortId().trim();
        this.result[4] = _ID2Data.getmID2Txt().getmBirthYear().trim();
        this.result[5] = _ID2Data.getmID2Txt().getmBirthMonth().trim();
        this.result[6] = _ID2Data.getmID2Txt().getmBirthDay().trim();
        this.result[7] = _ID2Data.getmID2Txt().getgatAddress().trim();
        this.result[8] = _ID2Data.getmID2Txt().getgatID2Num().trim();
        this.result[9] = _ID2Data.getmID2Txt().getgatIssue().trim();
        this.result[10] = _ID2Data.getmID2Txt().getgatStartDate().trim();
        this.result[11] = _ID2Data.getmID2Txt().getgatEndDate().trim();
        this.result[12] = SSUtil.toHexStringNoSpace(_ID2Data.getmID2Pic().getHeadFromCard(), _ID2Data.getmID2Pic().getHeadFromCard().length);
        this.result[20] = _ID2Data.getmID2Txt().getCardType();
        this.result[13] = _ID2Data.getmID2Txt().getgatSignCount().trim();
        if (_ID2Data.getmID2FP() == null) {
            this.result[14] = "-1";
        } else {
            this.result[14] = PARA_FP_POWEROFF;
            this.result[15] = _ID2Data.getmID2FP().getFingerPosition(1);
            this.result[16] = _ID2Data.getmID2FP().getFingerPosition(2);
            this.result[17] = SSUtil.toHexStringNoSpace(_ID2Data.getmID2FP().getmID2FPOne(), 512);
            this.result[18] = SSUtil.toHexStringNoSpace(_ID2Data.getmID2FP().getmID2FPTwo(), 512);
        }
        return this.result;
    }

    private String[] returnForiengerInfo(ID2Data _ID2Data) {
        this.result[0] = PARA_FP_POWEROFF;
        this.result[1] = _ID2Data.getmID2Txt().getfEame().trim();
        this.result[2] = _ID2Data.getmID2Txt().getfGender().trim();
        this.result[3] = _ID2Data.getmID2Txt().getfNum().trim();
        this.result[4] = _ID2Data.getmID2Txt().getfNation().trim();
        this.result[5] = _ID2Data.getmID2Txt().getfName().trim();
        this.result[6] = _ID2Data.getmID2Txt().getfStartDate().trim();
        this.result[7] = _ID2Data.getmID2Txt().getfEndDate().trim();
        this.result[8] = _ID2Data.getmID2Txt().getmBirthYear().trim();
        this.result[9] = _ID2Data.getmID2Txt().getmBirthMonth().trim();
        this.result[10] = _ID2Data.getmID2Txt().getmBirthDay().trim();
        this.result[11] = _ID2Data.getmID2Txt().getfNumVersion().trim();
        this.result[12] = SSUtil.toHexStringNoSpace(_ID2Data.getmID2Pic().getHeadFromCard(), _ID2Data.getmID2Pic().getHeadFromCard().length);
        this.result[13] = _ID2Data.getmID2Txt().getfNo();
        this.result[14] = _ID2Data.getmID2Txt().getfIssue();
        this.result[15] = _ID2Data.getmID2Txt().getfOldNum();
        this.result[20] = _ID2Data.getmID2Txt().getCardType();
        return this.result;
    }

    public String[] readCardInfo() {
        String mDevModel = Build.MODEL;
        if (mDevModel.equalsIgnoreCase("500C")) {
            this.openRFtoTypeB();
        } else if (mDevModel.equalsIgnoreCase("500CM")) {
            this.openRFtoTypeB100X1();
        } else if (mDevModel.equalsIgnoreCase("500CH")) {
            this.openRFtoTypeB();
        } else if (mDevModel.equalsIgnoreCase("500CT")) {
            this.openRFtoTypeB100X1();
        } else if (mDevModel.equalsIgnoreCase("JF106")) {
            this.openRFtoTypeB();
        } else if (mDevModel.contains("700E")) {
            this.openRFtoTypeB();
        } else if (mDevModel.equalsIgnoreCase("500BH")) {
            this.openRFtoTypeB();
        }
        if (this.mManageReadIDCard.searchID2Card()) {
            if (this.mManageReadIDCard.selectID2Card()) {
                if (this.mManageReadIDCard.readID2Card()) {
                    ((ID2Data)this.mManageReadIDCard.getmID2DataRAW()).rePackage();
                    ID2Data _ID2Data = (ID2Data)this.mManageReadIDCard.getmID2DataRAW();
                    if (_ID2Data.getmID2Txt().getCardType().equals("id2")) {
                        this.returnId2Info(_ID2Data);
                    } else if (_ID2Data.getmID2Txt().getCardType().equals("forienger")) {
                        this.returnForiengerInfo(_ID2Data);
                    } else if (_ID2Data.getmID2Txt().getCardType().equals("gatresidence")) {
                        this.returnGatResidenceInfo(_ID2Data);
                    }
                    return this.result;
                }
                this.result[0] = "-1";
                this.result[1] = "\u8bfb\u5361\u5931\u8d25";
                return this.result;
            }
            this.result[0] = "-1";
            this.result[1] = "\u8eab\u4efd\u8bc1\u9009\u5361\u9009\u5361\u5931\u8d25";
            return this.result;
        }
        this.result[0] = "-1";
        this.result[1] = "\u8eab\u4efd\u8bc1\u9009\u5361\u5bfb\u5361\u5931\u8d25";
        return this.result;
    }

    public boolean closeRFAll() {
        String mDevModel = Build.MODEL;
        if (mDevModel.equalsIgnoreCase("500C")) {
            this.closeRF();
        } else if (mDevModel.equalsIgnoreCase("500CM")) {
            this.closeRF100X1();
        } else if (mDevModel.equalsIgnoreCase("500CH")) {
            this.closeRF();
        } else if (mDevModel.equalsIgnoreCase("500CT")) {
            this.closeRF100X1();
        } else if (mDevModel.equalsIgnoreCase("JF106")) {
            this.closeRF();
        } else if (mDevModel.equalsIgnoreCase("700E")) {
            this.closeRF();
        } else if (mDevModel.equalsIgnoreCase("500BH")) {
            this.closeRF();
        }
        return true;
    }

    public boolean closeRF100X1() {
        byte[] data = new byte[256];
        int backInfact = 0;
        return 1 == this.mManageReadIDCard.Command100X1(9477, 0, data, 0, 15, backInfact, 200);
    }

    public int openReadCard() {
        int b = -1;
        try {
            String mDevModel = Build.MODEL;
            if (mDevModel.equalsIgnoreCase("M20D")) {
                ID2CardInterface.setGPIOPara(GPIO_PATH, "1");
            }
            if ("M20AT".equalsIgnoreCase(Build.MODEL)) {
                ID2CardInterface.setGPIOPara(M20AT_GPIO_PATH, "2");
            } else if ("m20".equalsIgnoreCase(Build.MODEL)) {
                ID2CardInterface.setGPIOPara(GPIO_PATH, "3");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        b = 1;
        return b;
    }

    public int closeReadCard() {
        int b = -1;
        try {
            if (Build.MODEL.equalsIgnoreCase("M20D")) {
                ID2CardInterface.setGPIOPara(GPIO_PATH, M20D_PARA_ID2_POWEROFF);
            }
            if ("M20AT".equalsIgnoreCase(Build.MODEL)) {
                ID2CardInterface.setGPIOPara(M20AT_GPIO_PATH, "h");
            } else if ("m20".equalsIgnoreCase(Build.MODEL)) {
                ID2CardInterface.setGPIOPara(GPIO_PATH, "2");
            }
            if (this.mDeviceConnection != null) {
                Log.w((String)TAG, (String)"USB releaseInterface");
                this.mDeviceConnection.releaseInterface(this.mInterface);
                this.mDeviceConnection.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        b = 1;
        return b;
    }

    private boolean openRFtoTypeB() {
        byte[] temp = new byte[256];
        int back = this.mManageReadIDCard.Command(65295, temp, 0, 11, 1, 200);
        return 1 == back && temp[7] == 0 && temp[8] == 0 && temp[9] == -112;
    }

    private boolean closeRF() {
        byte[] temp = new byte[256];
        int back = this.mManageReadIDCard.Command(65296, temp, 0, 11, 1, 200);
        if (1 == back && temp[7] == 0 && temp[8] == 0 && temp[9] == -112) {
            Log.w((String)TAG, (String)"\u5173\u5c04\u9891\u6210\u529f");
            return true;
        }
        return false;
    }

    private boolean openRFtoTypeB100X1() {
        Log.w((String)TAG, (String)"\u5207\u6362\u5230typeB\u6a21\u5f0f");
        byte[] data = new byte[256];
        int backInfact = 0;
        return 1 == this.mManageReadIDCard.Command100X1(9475, 0, data, 0, 15, backInfact, 200);
    }

    public int SS_USBConnect() {
        ioFile = new Files(this.mContext);
        this.manager = (UsbManager)this.mContext.getSystemService("usb");
        if (this.manager == null) {
            return -1;
        }
        Log.w((String)TAG, (String)("usb\u8bbe\u5907\uff1a" + String.valueOf(this.manager.toString())));
        HashMap deviceList = this.manager.getDeviceList();
        Log.e((String)TAG, (String)("usb\u8bbe\u5907\uff1a" + String.valueOf(deviceList.size())));
        Iterator deviceIterator = deviceList.values().iterator();
        while (deviceIterator.hasNext()) {
            Log.w((String)TAG, (String)"deviceIterator.hasNext()");
            UsbDevice device = (UsbDevice)deviceIterator.next();
            this.USBDeviceList.add(String.valueOf(device.getVendorId()));
            this.USBDeviceList.add(String.valueOf(device.getProductId()));
            Log.w((String)TAG, (String)("VID=" + device.getVendorId() + " PID=" + device.getProductId()));
            if (device.getVendorId() == 9754 && device.getProductId() == 17) {
                this.mUsbDevice = device;
                Log.e((String)"ss", (String)"\u627e\u5230\u8bfb\u5361 \u8bbe\u5907");
                break;
            }
            if (device.getVendorId() != 1024 || device.getProductId() != 50010) continue;
            this.mUsbDevice = device;
            Log.e((String)"ss", (String)"\u627e\u5230\u8bfb\u5361 \u8bbe\u5907");
            break;
        }
        Log.w((String)TAG, (String)"\u521b\u5efa\u4e00\u4e2aArrayAdapter");
        int result = this.findIntfAndEptNew();
        if (result == 0) {
            return 0;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int findIntfAndEptNew() {
        Log.w((String)TAG, (String)"[++++  findIntfAndEpt]");
        if (this.mUsbDevice == null) {
            Log.w((String)TAG, (String)"[findIntfAndEpt] \u6ca1\u6709\u627e\u5230\u8bbe\u5907");
            return -1;
        }
        this.manager.requestPermission(this.mUsbDevice, this.mPermissionIntent);
        Log.d((String)TAG, (String)("InterfaceCount=" + this.mUsbDevice.getInterfaceCount()));
        int i = 0;
        if (i < this.mUsbDevice.getInterfaceCount()) {
            UsbInterface intf = this.mUsbDevice.getInterface(i);
            Log.d((String)TAG, (String)(String.valueOf(i) + " " + intf));
            this.mInterface = intf;
        }
        if (this.mInterface == null) {
            Log.w((String)TAG, (String)"\u6ca1\u6709\u627e\u5230\u63a5\u53e3");
            return -4;
        }
        UsbDeviceConnection connection = null;
        if (!this.manager.hasPermission(this.mUsbDevice)) {
            Log.w((String)TAG, (String)"\u6ca1\u6709\u6743\u9650");
            return -3;
        }
        connection = this.manager.openDevice(this.mUsbDevice);
        if (connection == null) {
            return -2;
        }
        if (connection.claimInterface(this.mInterface, true)) {
            Log.w((String)TAG, (String)"\u627e\u5230\u63a5\u53e3");
            this.mDeviceConnection = connection;
            this.getEndpoint(this.mDeviceConnection, this.mInterface);
            if (this.mDeviceConnection == null) {
                Log.w((String)TAG, (String)"mDeviceConnection ==null");
            } else {
                Log.w((String)TAG, (String)"mDeviceConnection !=null");
            }
        } else {
            connection.close();
        }
        Log.w((String)TAG, (String)"[----  findIntfAndEpt]");
        return 0;
    }

    private UsbDevice openDevice() {
        int VendorId = 9754;
        int ProductId = 13;
        return AS60xIO.FCV_OpenDevice((Context)this.mContext, (int)VendorId, (int)13);
    }

    private void getEndpoint(UsbDeviceConnection connection, UsbInterface intf) {
        if (intf.getEndpoint(1) != null) {
            this.epOut = intf.getEndpoint(1);
        } else {
            Log.w((String)TAG, (String)"intf.getEndpoint(1) = null");
        }
        if (intf.getEndpoint(0) != null) {
            this.epIn = intf.getEndpoint(0);
        } else {
            Log.w((String)TAG, (String)"intf.getEndpoint(0) = null");
        }
    }

    public boolean searchCard() {
        String cmd = "AAAAAA96690003200122";
        byte[] sendSearch = Util.hexStr2ByteArray(cmd);
        byte[] recvData = new byte[64];
        int ret = this.mDeviceConnection.bulkTransfer(this.epOut, sendSearch, sendSearch.length, 1000);
        if (ret > 0 && (ret = this.mDeviceConnection.bulkTransfer(this.epIn, recvData, recvData.length, 1000)) > 0) {
            String recv = Util.toHexStringNoSpace(recvData, ret);
            return recvData[9] == -97;
        }
        return false;
    }

    public boolean selectCard() {
        String cmd = "AAAAAA96690003200221";
        byte[] sendSearch = Util.hexStr2ByteArray(cmd);
        byte[] recvData = new byte[64];
        int ret = this.mDeviceConnection.bulkTransfer(this.epOut, sendSearch, sendSearch.length, 1000);
        if (ret > 0 && (ret = this.mDeviceConnection.bulkTransfer(this.epIn, recvData, recvData.length, 1000)) > 0) {
            String recv = Util.toHexStringNoSpace(recvData, ret);
            return recvData[9] == -112;
        }
        return false;
    }

    public String[] readCard() {
        String[] idInfo;
        block11: {
            idInfo = new String[20];
            idInfo[1] = "-100";
            String cmd = "AAAAAA96690003301023";
            byte[] sendSearch = Util.hexStr2ByteArray(cmd);
            byte[] readAll = new byte[2500];
            byte[] cardInfo = new byte[2500];
            byte[] recvData = new byte[64];
            byte[] length = new byte[2];
            String fNumMark = "";
            Arrays.fill(this.idTxt, (byte)0);
            Arrays.fill(this.idPic, (byte)0);
            Arrays.fill(this.idFp, (byte)0);
            try {
                int ret = this.mDeviceConnection.bulkTransfer(this.epOut, sendSearch, sendSearch.length, 1000);
                Log.e((String)"", (String)("\u8bfb\u5361send:" + ret));
                if (ret <= 0) break block11;
                ret = this.mDeviceConnection.bulkTransfer(this.epIn, recvData, recvData.length, 3000);
                Log.e((String)"", (String)("\u8bfb\u5361recv:" + ret));
                if (ret > 0) {
                    if (recvData[9] == -112) {
                        System.arraycopy(recvData, 5, length, 0, 2);
                        System.arraycopy(recvData, 0, readAll, 0, 64);
                        int count = Integer.parseInt(SSUtil.toHexStringNoSpace(length, 2), 16);
                        Log.e((String)"", (String)("id2 length:" + count));
                        int bufInt = count;
                        int index = 64;
                        while (index < bufInt) {
                            this.length = index + this.max < bufInt ? this.max : bufInt - index;
                            ret = this.mDeviceConnection.bulkTransfer(this.epIn, recvData, recvData.length, 2000);
                            if (ret <= 0) {
                                Log.e((String)"", (String)"\u6ca1\u8bfb\u5b8c\u9000\u51fa\u4e86");
                                idInfo[0] = "-2";
                                return idInfo;
                            }
                            System.arraycopy(recvData, 0, readAll, index, this.length);
                            index += this.max;
                        }
                        System.arraycopy(readAll, 10, cardInfo, 0, count);
                        String recv = Util.toHexStringNoSpace(readAll, 1600);
                        String recvInfo = Util.toHexStringNoSpace(cardInfo, count);
                        this.isHaveFinger = false;
                        ID2Data id2Data = new ID2Data();
                        id2Data.decode(cardInfo);
                        id2Data.rePackage();
                        Log.e((String)"", (String)"\u8bfb\u5361success");
                        if (id2Data.getmID2Txt().getCardType().equals("id2")) {
                            idInfo = this.returnId2Info(id2Data);
                        } else if (id2Data.getmID2Txt().getCardType().equals("forienger")) {
                            idInfo = this.returnForiengerInfo(id2Data);
                        } else if (id2Data.getmID2Txt().getCardType().equals("gatresidence")) {
                            idInfo = this.returnGatResidenceInfo(id2Data);
                        }
                        break block11;
                    }
                    idInfo[1] = "-1";
                    return idInfo;
                }
                idInfo[1] = "-5";
                return idInfo;
            }
            catch (Exception e) {
                idInfo[1] = "-3";
                return idInfo;
            }
        }
        return idInfo;
    }

    public String[] readCard(byte[] cardinfobytes) {
        String[] idInfo;
        block11: {
            idInfo = new String[20];
            idInfo[1] = "-100";
            String cmd = "AAAAAA96690003301023";
            byte[] sendSearch = Util.hexStr2ByteArray(cmd);
            byte[] readAll = new byte[2500];
            byte[] cardInfo = new byte[2500];
            byte[] recvData = new byte[64];
            byte[] length = new byte[2];
            String fNumMark = "";
            Arrays.fill(this.idTxt, (byte)0);
            Arrays.fill(this.idPic, (byte)0);
            Arrays.fill(this.idFp, (byte)0);
            try {
                int ret = this.mDeviceConnection.bulkTransfer(this.epOut, sendSearch, sendSearch.length, 1000);
                Log.e((String)"", (String)("\u8bfb\u5361send:" + ret));
                if (ret <= 0) break block11;
                ret = this.mDeviceConnection.bulkTransfer(this.epIn, recvData, recvData.length, 3000);
                Log.e((String)"", (String)("\u8bfb\u5361recv:" + ret));
                if (ret > 0) {
                    if (recvData[9] == -112) {
                        System.arraycopy(recvData, 5, length, 0, 2);
                        System.arraycopy(recvData, 0, readAll, 0, 64);
                        int count = Integer.parseInt(SSUtil.toHexStringNoSpace(length, 2), 16);
                        Log.e((String)"", (String)("id2 length:" + count));
                        int bufInt = count;
                        int index = 64;
                        while (index < bufInt) {
                            this.length = index + this.max < bufInt ? this.max : bufInt - index;
                            ret = this.mDeviceConnection.bulkTransfer(this.epIn, recvData, recvData.length, 2000);
                            if (ret <= 0) {
                                Log.e((String)"", (String)"\u6ca1\u8bfb\u5b8c\u9000\u51fa\u4e86");
                                idInfo[0] = "-2";
                                return idInfo;
                            }
                            System.arraycopy(recvData, 0, readAll, index, this.length);
                            index += this.max;
                        }
                        System.arraycopy(readAll, 10, cardInfo, 0, count);
                        System.arraycopy(readAll, 16, cardinfobytes, 0, count - 6);
                        String recv = Util.toHexStringNoSpace(readAll, 1600);
                        String recvInfo = Util.toHexStringNoSpace(cardInfo, count);
                        this.isHaveFinger = false;
                        ID2Data id2Data = new ID2Data();
                        id2Data.decode(cardInfo);
                        id2Data.rePackage();
                        Log.e((String)"", (String)"\u8bfb\u5361success");
                        if (id2Data.getmID2Txt().getCardType().equals("id2")) {
                            idInfo = this.returnId2Info(id2Data);
                        } else if (id2Data.getmID2Txt().getCardType().equals("forienger")) {
                            idInfo = this.returnForiengerInfo(id2Data);
                        } else if (id2Data.getmID2Txt().getCardType().equals("gatresidence")) {
                            idInfo = this.returnGatResidenceInfo(id2Data);
                        }
                        break block11;
                    }
                    idInfo[1] = "-1";
                    return idInfo;
                }
                idInfo[1] = "-5";
                return idInfo;
            }
            catch (Exception e) {
                idInfo[1] = "-3";
                return idInfo;
            }
        }
        return idInfo;
    }

    public boolean closeRf() {
        String cmd = "AAAAAA960A0003FF10EC";
        byte[] sendSearch = Util.hexStr2ByteArray(cmd);
        byte[] recvData = new byte[64];
        int ret = this.mDeviceConnection.bulkTransfer(this.epOut, sendSearch, sendSearch.length, 1000);
        if (ret > 0 && (ret = this.mDeviceConnection.bulkTransfer(this.epIn, recvData, recvData.length, 1000)) > 0) {
            String recv = Util.toHexStringNoSpace(recvData, ret);
            return recvData[9] == -112;
        }
        return false;
    }

    private static void setGPIOPara(String path, String para) {
        try {
            FileWriter localFileWriterOn = new FileWriter(new File(path));
            localFileWriterOn.write(para);
            localFileWriterOn.close();
        }
        catch (Exception var3) {
            var3.printStackTrace();
        }
    }

    public String readM1Card(byte KeyType, byte SecAddr, byte[] key, byte BlockAddr) {
        long[] BlockDataLen;
        byte[] BlockData;
        block7: {
            long res;
            block6: {
                byte[] uid;
                block5: {
                    try {
                        Log.e((String)"ss", (String)"m1\u5361 \u8bfb\u5361");
                        long[] uidLen = new long[1];
                        uid = new byte[16];
                        BlockData = new byte[64];
                        BlockDataLen = new long[1];
                        res = JniCommonInterface.M1FindCard(uid, uidLen);
                        Log.e((String)"ss", (String)("m1\u5361 \u5bfb\u5361" + res));
                        if (res == 0L) break block5;
                        Log.e((String)"ss", (String)"m1\u5361 \u5bfb\u5361\u5931\u8d25");
                        return null;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                res = JniCommonInterface.M1Authentication(KeyType, SecAddr, key, uid);
                Log.e((String)"ss", (String)("m1\u5361 \u9a8c\u8bc1" + res));
                if (res == 0L) break block6;
                Log.e((String)"ss", (String)("m1\u5361 \u9a8c\u8bc1\u5931\u8d25" + res));
                return null;
            }
            res = JniCommonInterface.M1ReadBlock(BlockAddr, BlockData, BlockDataLen);
            Log.e((String)"ss", (String)("m1\u5361 \u8bfb\u5361" + res));
            if (res == 0L) break block7;
            Log.e((String)"ss", (String)"m1\u5361 \u8bfb\u5361\u5931\u8d25");
            return null;
        }
        Log.e((String)"ss", (String)"m1\u5361 \u8bfb\u5361\u6210\u529f");
        byte[] BlockDataStr = new byte[32];
        JniCommonInterface.HexToAsc(BlockData, BlockDataLen[0], BlockDataStr);
        Log.e((String)"ss", (String)("m1\u5361 \u8bfb\u5361\u6210\u529f" + new String(BlockDataStr).trim()));
        return new String(BlockDataStr, "GBK").trim();
    }

    public String getSamSn() {
        byte[] temp = new byte[26];
        int num = this.oneCommand("12FF", 100, 36, 4, 86, 102);
        if (this.dataBytes[0] == 83 && this.dataBytes[1] == 68 && this.dataBytes[2] == 115 && this.dataBytes[3] == 69 && this.dataBytes[4] == 115 && this.dataBytes[12] == -112) {
            System.arraycopy(this.dataBytes, 13, temp, 0, 26);
            return this.getSAMSN(temp);
        }
        return "";
    }

    public String getSAMSN(byte[] temp) {
        short[] PNO = new short[16];
        short head1 = 0;
        short head2 = 0;
        long data1 = 0L;
        long data2 = 0L;
        long data3 = 0L;
        String dstStr = null;
        if (temp[5] == 0 && temp[6] == 20 && temp[7] == 0 && temp[8] == 0 && temp[9] == -112) {
            int j = 0;
            while (j < 16) {
                PNO[j] = temp[10 + j] < 0 ? (short)(256 + temp[10 + j]) : (short)temp[10 + j];
                ++j;
            }
            head1 = (short)(PNO[1] * 256 + PNO[0]);
            head2 = (short)(PNO[3] * 256 + PNO[2]);
            data1 = (long)PNO[4] + (long)PNO[5] * 256L + (long)PNO[6] * 256L * 256L + (long)PNO[7] * 256L * 256L * 256L;
            data2 = (long)PNO[8] + (long)PNO[9] * 256L + (long)PNO[10] * 256L * 256L + (long)PNO[11] * 256L * 256L * 256L;
            data3 = (long)PNO[12] + (long)PNO[13] * 256L + (long)PNO[14] * 256L * 256L + (long)PNO[15] * 256L * 256L * 256L;
            Log.i((String)"SAM", (String)String.format("%02d.%02d-%08d-%010d-%010d", head1, head2, data1, data2, data3));
            dstStr = String.format("%02d.%02d-%08d-%010d-%010d", head1, head2, data1, data2, data3);
        }
        if (dstStr != null) {
            Log.i((String)"SAM", (String)("SAM\u6a21\u5757\u53f7:" + dstStr));
        }
        return dstStr;
    }

    private int oneCommand(String cmd, int timeout, int cmd1, int cmd2, int crc1, int crc2) {
        int ret = 0;
        int len = 0;
        try {
            ret = this.mDeviceConnection.bulkTransfer(this.epOut, this.getTmep(cmd1, cmd2, crc1, crc2), 64, 100);
            Arrays.fill(this.dataBytes, (byte)0);
            Arrays.fill(this.receiveBytes, (byte)0);
            ret = this.mDeviceConnection.bulkTransfer(this.epIn, this.receiveBytes, this.USB_ACKLEN, timeout);
            if (ret > 0 && ret > 1) {
                len = (this.receiveBytes[0] & 0xFF) << 8 | this.receiveBytes[1] & 0xFF;
                System.arraycopy(this.receiveBytes, 0, this.dataBytes, 0, 64);
                if (len > ret) {
                    int i = 1;
                    Arrays.fill(this.receiveBytes, (byte)0);
                    while (this.mDeviceConnection.bulkTransfer(this.epIn, this.receiveBytes, 64, 50) > 0) {
                        System.arraycopy(this.receiveBytes, 0, this.dataBytes, 64 * i++, 64);
                        Arrays.fill(this.receiveBytes, (byte)0);
                        ret += 64;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = -1;
        }
        return ret;
    }

    private byte[] getTmep(int cmd1, int cmd2, int crc1, int crc2) {
        byte[] temp = new byte[512];
        byte[] head = new byte[]{83, 68, 115, 69, 115};
        System.arraycopy(head, 0, temp, 0, head.length);
        temp[6] = 0;
        temp[7] = 0;
        temp[8] = 0;
        temp[9] = 4;
        temp[10] = (byte)cmd1;
        temp[11] = (byte)cmd2;
        temp[12] = (byte)crc1;
        temp[13] = (byte)crc2;
        return temp;
    }
}

