/*
 * Decompiled with CFR 0.152.
 */
package com.sdses.bean;

import android.util.Log;
import java.io.Serializable;
import java.util.Arrays;

public class ID2FP
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TAG = ID2FP.class.getSimpleName();
    private byte[] mID2FPOne = new byte[512];
    private byte[] mID2FPTwo = new byte[512];

    public boolean initFP(byte[] _fingerprint) {
        if (_fingerprint != null && _fingerprint.length >= 1024) {
            Log.i((String)TAG, (String)"\u590d\u5236\u6307\u7eb9\u6570\u636e");
            System.arraycopy(_fingerprint, 0, this.mID2FPOne, 0, 512);
            System.arraycopy(_fingerprint, 512, this.mID2FPTwo, 0, 512);
            return true;
        }
        Log.i((String)TAG, (String)"\u672a\u53d1\u73b0\u6307\u7eb9\u6570\u636e");
        Arrays.fill(this.mID2FPOne, (byte)0);
        Arrays.fill(this.mID2FPTwo, (byte)0);
        return false;
    }

    public byte[] getmID2FPOne() {
        return this.mID2FPOne;
    }

    public byte[] getmID2FPTwo() {
        return this.mID2FPTwo;
    }

    public String getFingerPosition(int _num) {
        if (_num == 1) {
            if (this.mID2FPOne[0] == 67) {
                return this._getFingerPosition(this.mID2FPOne[5]);
            }
        } else if (_num == 2 && this.mID2FPTwo[0] == 67) {
            return this._getFingerPosition(this.mID2FPTwo[5]);
        }
        return null;
    }

    private String _getFingerPosition(byte _key) {
        String back = null;
        switch (_key) {
            case 11: {
                back = "\u53f3\u624b\u62c7\u6307";
                break;
            }
            case 12: {
                back = "\u53f3\u624b\u98df\u6307";
                break;
            }
            case 13: {
                back = "\u53f3\u624b\u4e2d\u6307";
                break;
            }
            case 14: {
                back = "\u53f3\u624b\u73af\u6307";
                break;
            }
            case 15: {
                back = "\u53f3\u624b\u5c0f\u6307";
                break;
            }
            case 16: {
                back = "\u5de6\u624b\u62c7\u6307";
                break;
            }
            case 17: {
                back = "\u5de6\u624b\u98df\u6307";
                break;
            }
            case 18: {
                back = "\u5de6\u624b\u4e2d\u6307";
                break;
            }
            case 19: {
                back = "\u5de6\u624b\u73af\u6307";
                break;
            }
            case 20: {
                back = "\u5de6\u624b\u5c0f\u6307";
                break;
            }
            case 97: {
                back = "\u53f3\u624b\u4e0d\u786e\u5b9a\u6307\u4f4d";
                break;
            }
            case 98: {
                back = "\u5de6\u624b\u4e0d\u786e\u5b9a\u6307\u4f4d";
                break;
            }
            case 99: {
                back = "\u5176\u4ed6\u4e0d\u786e\u5b9a\u6307\u4f4d";
                break;
            }
            default: {
                back = null;
            }
        }
        return back;
    }
}

