/*
 * Decompiled with CFR 0.152.
 */
package com.sdses.id2CardInterface;

import android.content.Context;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import com.sdses.JniCommonInterface;
import com.sdses.bean.ID2Data;
import com.sdses.bean.ID2FP;
import com.sdses.fingerJar.Util;
import com.sdses.manage.ManageReadIDCard;
import com.sdses.tool.SSUtil;
import java.io.File;
import java.io.FileWriter;

public class ID2InterfaceForM20 {
    public static final String GPIO_PATH = "/sys/bus/platform/drivers/gpioctrl_sdses/gpioctrl/gpioctrl_sdses";
    public static final String M20D_PARA_ID2_POWERON = "1";
    public static final String M20D_PARA_ID2_POWEROFF = "g";
    public static final String PARA_ID2_POWERON = "3";
    public static final String PARA_ID2_POWEROFF = "2";
    public static final String PARA_FP_POWERON = "1";
    public static final String PARA_FP_POWEROFF = "0";
    public static final String M20AT_GPIO_PATH = "/sys/bus/platform/drivers/gpioctrl_sdses/GpioCtrl_sdses/gpioctrl_sdses";
    public static final String M20AT_PARA_ID2_POWER_ON = "2";
    public static final String M20AT_PARA_ID2_POWEROFF = "h";
    public static final String M20AT_PARA_FP_POWER_ON = "3";
    public static final String M20AT_PARA_FP_POWER_OFF = "i";
    public static final String PARA_ID2_POWER_ON_M20AT = "2";
    public static final String PARA_ID2_POWER_OFF_M20AT = "h";
    public static final String PARA_FP_POWER_ON_M20AT = "3";
    public static final String PARA_FP_POWER_OFF_M20AT = "i";
    private Context mContext;
    ManageReadIDCard mManageReadIDCard;
    public static final String TAG = "id2CardInterface";
    private ID2FP mID2FP = null;
    String[] result = new String[22];
    byte[] idTxt = new byte[256];
    byte[] idPic = new byte[1024];
    byte[] idFp = new byte[1024];
    long[] lenIdTxt = new long[1];
    long[] lenPicTxt = new long[1];
    long[] lenFPTxt = new long[1];

    public ID2InterfaceForM20(Context context) {
        this.mContext = context;
        this.mManageReadIDCard = new ManageReadIDCard();
        this.mManageReadIDCard.getID2DataController("com.sdses.bean.ID2Data");
        this.mManageReadIDCard.getID2CardReader("com.sdses.common.impl.ReadCardFromSerialport");
    }

    public boolean searchID2Card() {
        return this.mManageReadIDCard.selectID2Card();
    }

    public String[] readCardInfoNew() {
        if (this.mManageReadIDCard.readID2Card()) {
            ((ID2Data)this.mManageReadIDCard.getmID2DataRAW()).rePackage();
            ID2Data _ID2Data = (ID2Data)this.mManageReadIDCard.getmID2DataRAW();
            if (_ID2Data.getmID2Txt().getCardType().equals("id2")) {
                this.returnId2Info(_ID2Data);
            } else {
                this.returnForiengerInfo(_ID2Data);
            }
            return this.result;
        }
        this.result[0] = "-1";
        this.result[1] = "\u8bfb\u5361\u5931\u8d25";
        return this.result;
    }

    private String[] returnId2Info(ID2Data _ID2Data) {
        this.result[0] = PARA_FP_POWEROFF;
        this.result[1] = _ID2Data.getmID2Txt().getmName().trim();
        this.result[2] = _ID2Data.getmID2Txt().getmGender().trim();
        this.result[3] = _ID2Data.getmID2Txt().getmNational().trim();
        this.result[4] = _ID2Data.getmID2Txt().getmBirthYear().trim();
        this.result[5] = _ID2Data.getmID2Txt().getmBirthMonth().trim();
        this.result[6] = _ID2Data.getmID2Txt().getmBirthDay().trim();
        this.result[7] = _ID2Data.getmID2Txt().getmAddress().trim();
        this.result[8] = _ID2Data.getmID2Txt().getmID2Num().trim();
        this.result[9] = _ID2Data.getmID2Txt().getmIssue().trim();
        this.result[10] = _ID2Data.getmID2Txt().getmBegin().trim();
        this.result[11] = _ID2Data.getmID2Txt().getmEnd().trim();
        this.result[12] = SSUtil.toHexStringNoSpace(_ID2Data.getmID2Pic().getHeadFromCard(), _ID2Data.getmID2Pic().getHeadFromCard().length);
        this.result[20] = _ID2Data.getmID2Txt().getCardType();
        this.result[13] = _ID2Data.getmID2NewAddress() != null ? _ID2Data.getmID2NewAddress() : "-1";
        if (_ID2Data.getmID2FP() == null) {
            this.result[14] = "-1";
        } else {
            this.result[14] = PARA_FP_POWEROFF;
            this.result[15] = _ID2Data.getmID2FP().getFingerPosition(1);
            this.result[16] = _ID2Data.getmID2FP().getFingerPosition(2);
            this.result[17] = SSUtil.toHexStringNoSpace(_ID2Data.getmID2FP().getmID2FPOne(), 512);
            this.result[18] = SSUtil.toHexStringNoSpace(_ID2Data.getmID2FP().getmID2FPTwo(), 512);
        }
        return this.result;
    }

    private String[] returnForiengerInfo(ID2Data _ID2Data) {
        this.result[0] = PARA_FP_POWEROFF;
        this.result[1] = _ID2Data.getmID2Txt().getfEame().trim();
        this.result[2] = _ID2Data.getmID2Txt().getfGender().trim();
        this.result[3] = _ID2Data.getmID2Txt().getfNum().trim();
        this.result[4] = _ID2Data.getmID2Txt().getfNation().trim();
        this.result[5] = _ID2Data.getmID2Txt().getfName().trim();
        this.result[6] = _ID2Data.getmID2Txt().getfStartDate().trim();
        this.result[7] = _ID2Data.getmID2Txt().getfEndDate().trim();
        this.result[8] = _ID2Data.getmID2Txt().getmBirthYear().trim();
        this.result[9] = _ID2Data.getmID2Txt().getmBirthMonth().trim();
        this.result[10] = _ID2Data.getmID2Txt().getmBirthDay().trim();
        this.result[11] = _ID2Data.getmID2Txt().getfNumVersion().trim();
        this.result[12] = SSUtil.toHexStringNoSpace(_ID2Data.getmID2Pic().getHeadFromCard(), _ID2Data.getmID2Pic().getHeadFromCard().length);
        this.result[13] = _ID2Data.getmID2Txt().getfNo();
        this.result[14] = _ID2Data.getmID2Txt().getfIssue();
        this.result[20] = _ID2Data.getmID2Txt().getCardType();
        return this.result;
    }

    public String[] readCardInfo() {
        String mDevModel = Build.MODEL;
        if (mDevModel.equalsIgnoreCase("500C")) {
            this.openRFtoTypeB();
        } else if (mDevModel.equalsIgnoreCase("500CM")) {
            this.openRFtoTypeB100X1();
        } else if (mDevModel.equalsIgnoreCase("500CH")) {
            this.openRFtoTypeB();
        } else if (mDevModel.equalsIgnoreCase("500CT")) {
            this.openRFtoTypeB100X1();
        } else if (mDevModel.equalsIgnoreCase("JF106")) {
            this.openRFtoTypeB();
        } else if (mDevModel.contains("700E")) {
            this.openRFtoTypeB();
        } else if (mDevModel.equalsIgnoreCase("500BH")) {
            this.openRFtoTypeB();
        }
        if (this.mManageReadIDCard.searchID2Card()) {
            if (this.mManageReadIDCard.selectID2Card()) {
                if (this.mManageReadIDCard.readID2Card()) {
                    ((ID2Data)this.mManageReadIDCard.getmID2DataRAW()).rePackage();
                    ID2Data _ID2Data = (ID2Data)this.mManageReadIDCard.getmID2DataRAW();
                    if (_ID2Data.getmID2Txt().getCardType().equals("id2")) {
                        this.returnId2Info(_ID2Data);
                    } else {
                        this.returnForiengerInfo(_ID2Data);
                    }
                    return this.result;
                }
                this.result[0] = "-1";
                this.result[1] = "\u8bfb\u5361\u5931\u8d25";
                return this.result;
            }
            this.result[0] = "-1";
            this.result[1] = "\u8eab\u4efd\u8bc1\u9009\u5361\u9009\u5361\u5931\u8d25";
            return this.result;
        }
        this.result[0] = "-1";
        this.result[1] = "\u8eab\u4efd\u8bc1\u9009\u5361\u5bfb\u5361\u5931\u8d25";
        return this.result;
    }

    public boolean closeRFAll() {
        String mDevModel = Build.MODEL;
        if (mDevModel.equalsIgnoreCase("500C")) {
            this.closeRF();
        } else if (mDevModel.equalsIgnoreCase("500CM")) {
            this.closeRF100X1();
        } else if (mDevModel.equalsIgnoreCase("500CH")) {
            this.closeRF();
        } else if (mDevModel.equalsIgnoreCase("500CT")) {
            this.closeRF100X1();
        } else if (mDevModel.equalsIgnoreCase("JF106")) {
            this.closeRF();
        } else if (mDevModel.equalsIgnoreCase("700E")) {
            this.closeRF();
        } else if (mDevModel.equalsIgnoreCase("500BH")) {
            this.closeRF();
        }
        return true;
    }

    public boolean closeRF100X1() {
        byte[] data = new byte[256];
        int backInfact = 0;
        return 1 == this.mManageReadIDCard.Command100X1(9477, 0, data, 0, 15, backInfact, 200);
    }

    public int openReadCard() {
        long ret;
        int b;
        block8: {
            b = -1;
            String mDevModel = Build.MODEL;
            Log.e((String)"ss", (String)"openReadCard");
            if (mDevModel.equalsIgnoreCase("M20D")) {
                ID2InterfaceForM20.setGPIOPara(GPIO_PATH, "1");
            }
            if ("M20AT".equalsIgnoreCase(Build.MODEL)) {
                ID2InterfaceForM20.setGPIOPara(M20AT_GPIO_PATH, "2");
            } else if ("m20".equalsIgnoreCase(Build.MODEL)) {
                ID2InterfaceForM20.setGPIOPara(GPIO_PATH, "3");
            }
            SystemClock.sleep((long)600L);
            ret = JniCommonInterface.GetUsbPermission(this.mContext, 9754, 17);
            Log.e((String)"ss", (String)("\u6743\u9650\uff1a" + ret));
            if (ret == 0L) break block8;
            return -1;
        }
        try {
            ret = JniCommonInterface.OpenDevice("USB", "261A0011", "");
            if (ret > 0L) {
                b = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    public int closeReadCard() {
        int b = -1;
        try {
            if (Build.MODEL.equalsIgnoreCase("M20D")) {
                ID2InterfaceForM20.setGPIOPara(GPIO_PATH, M20D_PARA_ID2_POWEROFF);
            }
            if ("M20AT".equalsIgnoreCase(Build.MODEL)) {
                ID2InterfaceForM20.setGPIOPara(M20AT_GPIO_PATH, "h");
            } else if ("m20".equalsIgnoreCase(Build.MODEL)) {
                ID2InterfaceForM20.setGPIOPara(GPIO_PATH, "2");
            }
            JniCommonInterface.CloseDevice();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    private boolean openRFtoTypeB() {
        byte[] temp = new byte[256];
        int back = this.mManageReadIDCard.Command(65295, temp, 0, 11, 1, 200);
        return 1 == back && temp[7] == 0 && temp[8] == 0 && temp[9] == -112;
    }

    private boolean closeRF() {
        byte[] temp = new byte[256];
        int back = this.mManageReadIDCard.Command(65296, temp, 0, 11, 1, 200);
        if (1 == back && temp[7] == 0 && temp[8] == 0 && temp[9] == -112) {
            Log.w((String)TAG, (String)"\u5173\u5c04\u9891\u6210\u529f");
            return true;
        }
        return false;
    }

    private boolean openRFtoTypeB100X1() {
        Log.w((String)TAG, (String)"\u5207\u6362\u5230typeB\u6a21\u5f0f");
        byte[] data = new byte[256];
        int backInfact = 0;
        return 1 == this.mManageReadIDCard.Command100X1(9475, 0, data, 0, 15, backInfact, 200);
    }

    private static void setGPIOPara(String path, String para) {
        try {
            FileWriter localFileWriterOn = new FileWriter(new File(path));
            localFileWriterOn.write(para);
            localFileWriterOn.close();
        }
        catch (Exception var3) {
            var3.printStackTrace();
        }
    }

    public boolean searchCard() {
        long ret = JniCommonInterface.IdFindCard();
        return ret == 0L;
    }

    public boolean selectCard() {
        long ret = JniCommonInterface.IdSelectCard();
        return ret == 0L;
    }

    public String[] readCard() {
        String[] idInfo = new String[20];
        JniCommonInterface.IdReadBaseFpMsg(this.idTxt, this.lenIdTxt, this.idPic, this.lenPicTxt, this.idFp, this.lenFPTxt);
        long len = this.lenIdTxt[0];
        long len2 = this.lenPicTxt[0];
        long len3 = this.lenFPTxt[0];
        Log.e((String)"idtxt", (String)("idtxt:" + len + ":" + len2 + "lenfp:" + len3));
        if (len == 256L && len2 == 1024L) {
            ID2Data id2Data = new ID2Data();
            id2Data.rePackage(this.idTxt, this.idPic, this.idFp);
            Log.e((String)"ss", (String)("id2Data:" + id2Data.getmID2Txt().getCardType()));
            Log.e((String)"ss", (String)("id2Data name:" + id2Data.getmID2Txt().getmName()));
            idInfo = id2Data.getmID2Txt().getCardType().equals("id2") ? this.returnId2Info(id2Data) : this.returnForiengerInfo(id2Data);
            return idInfo;
        }
        idInfo[0] = "-1";
        return idInfo;
    }

    public String readM1Card(byte KeyType, byte SecAddr, byte[] key, byte BlockAddr) {
        long[] BlockDataLen;
        byte[] BlockData;
        block7: {
            long res;
            block6: {
                byte[] uid;
                block5: {
                    try {
                        Log.e((String)"ss", (String)"m1\u5361 \u8bfb\u5361");
                        long[] uidLen = new long[1];
                        uid = new byte[16];
                        BlockData = new byte[64];
                        BlockDataLen = new long[1];
                        res = JniCommonInterface.M1FindCard(uid, uidLen);
                        Log.e((String)"ss", (String)("m1\u5361 \u5bfb\u5361" + res));
                        if (res == 0L) break block5;
                        Log.e((String)"ss", (String)"m1\u5361 \u5bfb\u5361\u5931\u8d25");
                        return null;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                res = JniCommonInterface.M1Authentication(KeyType, SecAddr, key, uid);
                Log.e((String)"ss", (String)("m1\u5361 \u9a8c\u8bc1" + res));
                if (res == 0L) break block6;
                Log.e((String)"ss", (String)("m1\u5361 \u9a8c\u8bc1\u5931\u8d25" + res));
                return null;
            }
            res = JniCommonInterface.M1ReadBlock(BlockAddr, BlockData, BlockDataLen);
            Log.e((String)"ss", (String)("m1\u5361 \u8bfb\u5361" + res));
            if (res == 0L) break block7;
            Log.e((String)"ss", (String)"m1\u5361 \u8bfb\u5361\u5931\u8d25");
            return null;
        }
        Log.e((String)"ss", (String)"m1\u5361 \u8bfb\u5361\u6210\u529f");
        byte[] BlockDataStr = new byte[32];
        JniCommonInterface.HexToAsc(BlockData, BlockDataLen[0], BlockDataStr);
        Log.e((String)"ss", (String)("m1\u5361 \u8bfb\u5361\u6210\u529f" + new String(BlockDataStr).trim()));
        return new String(BlockDataStr, "GBK").trim();
    }

    public int ReadSdsesCard() {
        byte[] ATRS = new byte[128];
        long[] ATRSLen = new long[1];
        long ret = JniCommonInterface.CpuPowerOn((byte)65, ATRS, ATRSLen);
        Log.e((String)"ss", (String)("\u5458\u5de5\u5361\u4e0a\u7535" + ret));
        if (ret != 0L) {
            return -2;
        }
        byte[] byArray = new byte[7];
        byArray[1] = -92;
        byArray[2] = 2;
        byArray[4] = 2;
        byArray[5] = -17;
        byArray[6] = 5;
        byte[] apdu_select_ef05 = byArray;
        byte[] apdu_select_ef05_response = new byte[1024];
        long[] apdu_select_ef05_response_len = new long[10];
        ret = JniCommonInterface.CpuApdu((byte)65, apdu_select_ef05.length, apdu_select_ef05, apdu_select_ef05_response, apdu_select_ef05_response_len);
        Log.e((String)"ss", (String)("\u5458\u5de5\u5361\u9009\u62e9EF05" + ret));
        if (ret != 0L || !Util.toHexStringNoSpace(apdu_select_ef05_response, 1).equals("90")) {
            Log.e((String)"ss", (String)("\u5458\u5de5\u5361\u9009\u62e9EF05\u5931\u8d25" + Util.toHexStringNoSpace(apdu_select_ef05_response, 1)));
            return -3;
        }
        byte[] byArray2 = new byte[5];
        byArray2[1] = -80;
        byArray2[3] = 79;
        byArray2[4] = 8;
        byte[] apdu_read_binary = byArray2;
        byte[] apdu_read_binary_response = new byte[1024];
        long[] apdu_read_binary_response_len = new long[1];
        ret = JniCommonInterface.CpuApdu((byte)65, apdu_read_binary.length, apdu_read_binary, apdu_read_binary_response, apdu_read_binary_response_len);
        long len = apdu_read_binary_response_len[0];
        Log.e((String)"ss", (String)("\u5458\u5de5\u5361\u957f\u5ea6\uff1a" + Util.toHexStringNoSpace(apdu_read_binary_response, (int)len)));
        if (ret != 0L || apdu_read_binary_response[(int)(len - 2L)] != -112) {
            Log.e((String)"ss", (String)("\u5458\u5de5\u5361\u8bfb\u4e8c\u8fdb\u5236\u5931\u8d25" + apdu_read_binary_response[(int)(len - 2L)]));
            return -4;
        }
        byte[] lenCard = new byte[4];
        System.arraycopy(apdu_read_binary_response, 4, lenCard, 0, 4);
        int cardnum = Integer.parseInt(Util.toHexStringNoSpace(lenCard, 4), 16);
        ret = JniCommonInterface.CpuPowerOff((byte)65);
        return cardnum;
    }
}

