/*
 * Decompiled with CFR 0.152.
 */
package com.hisign.AS60xSDK;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.hisign.AS60xSDK.FpCapProcessAPI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

@TargetApi(value=12)
public class AS60xDatas {
    private static final String TAG = "AS60xDatas";
    private static final int UdiskERROR = -101;
    private UsbManager mUsbManager = null;
    private UsbEndpoint mEndpointIn = null;
    private UsbEndpoint mEndpointOut = null;
    private UsbDeviceConnection mConnection = null;
    private int mEpOutjni = 2;
    private int mEpInjni = 129;
    private int timeOut = 5000;

    private UsbEndpoint GetEndPoint(UsbDevice device, int nEndpoint) {
        UsbInterface intf;
        UsbEndpoint ep1 = null;
        if (device != null && (ep1 = (intf = device.getInterface(0)).getEndpoint(nEndpoint)).getType() != 2) {
            ep1 = null;
        }
        return ep1;
    }

    private boolean GetUsbEndpoints(UsbDevice device) {
        this.mEndpointIn = this.GetEndPoint(device, 0);
        this.mEndpointOut = this.GetEndPoint(device, 1);
        return this.mEndpointIn != null && this.mEndpointOut != null;
    }

    private UsbDeviceConnection GetConnection(UsbDevice device) {
        UsbDeviceConnection connection = null;
        if (device != null && this.mUsbManager != null && this.mUsbManager.hasPermission(device)) {
            UsbInterface intf = device.getInterface(0);
            connection = this.mUsbManager.openDevice(device);
            if (connection == null || !connection.claimInterface(intf, true)) {
                Log.e((String)TAG, (String)"open device failed!!");
                connection = null;
            }
        } else {
            Log.e((String)TAG, (String)"usb has not Permission !");
        }
        return connection;
    }

    UsbDevice OpenAS60xDevice(Context mContext, int VendorId, int ProductId) {
        UsbDevice mdevice = null;
        Log.d((String)TAG, (String)"getSystemService(Context.USB_SERVICE)");
        this.mUsbManager = (UsbManager)mContext.getSystemService("usb");
        if (this.mUsbManager == null) {
            Log.d((String)TAG, (String)"mUsbManager == null return!!!");
            return null;
        }
        Log.d((String)TAG, (String)("mUsbManager=" + this.mUsbManager));
        HashMap deviceList = this.mUsbManager.getDeviceList();
        Log.d((String)TAG, (String)("devicelist=" + deviceList));
        if (deviceList.isEmpty()) {
            Log.d((String)TAG, (String)"deviceList.isEmpty");
        }
        Log.d((String)TAG, (String)"1........");
        Iterator deviceIterator = deviceList.values().iterator();
        Log.d((String)TAG, (String)("get device list  = " + deviceList.size()));
        if (!deviceIterator.hasNext()) {
            Log.i((String)TAG, (String)"Device has no next:");
        }
        while (deviceIterator.hasNext()) {
            UsbDevice device = null;
            device = (UsbDevice)deviceIterator.next();
            String devInfo = String.valueOf(device.getDeviceName()) + "(" + device.getVendorId() + ":" + device.getProductId() + ")";
            Log.e((String)TAG, (String)devInfo);
            if (device.getVendorId() != VendorId || device.getProductId() != ProductId) continue;
            Log.d((String)TAG, (String)"AS60x-mdevice found!");
            mdevice = device;
            boolean flag = this.GetUsbEndpoints(mdevice);
            if (!flag) {
                Log.d((String)TAG, (String)"Sorry, AS60x-GetUsbEndpoints failed!!!");
                return null;
            }
            Log.d((String)TAG, (String)"AS60x-GetUsbEndpoints Succeed!!!");
            break;
        }
        return mdevice;
    }

    void tranSmitEndPointParamsJni(int mEpOut, int mEpIn) {
        this.mEpOutjni = mEpOut;
        this.mEpInjni = mEpIn;
        Log.d((String)TAG, (String)("mEpOutjni==" + this.mEpOutjni + " mEpInjni=" + this.mEpInjni));
    }

    private int UDiskDownData(byte[] pBuf, int nLen) {
        return this.UDiskDownData(pBuf, nLen, this.timeOut);
    }

    private int UDiskDownData(byte[] pBuf, int nLen, int nTimeOut) {
        int ret = -1;
        int i = 0;
        byte[] byArray = new byte[32];
        byArray[0] = 85;
        byArray[1] = 83;
        byArray[2] = 66;
        byArray[3] = 67;
        byArray[4] = 83;
        byArray[5] = 121;
        byArray[6] = 110;
        byArray[7] = 111;
        byArray[14] = 10;
        byArray[15] = -122;
        byte[] do_CBW = byArray;
        byte[] di_CSW = new byte[16];
        do_CBW[8] = (byte)(nLen & 0xFF);
        do_CBW[9] = (byte)(nLen >> 8 & 0xFF);
        do_CBW[10] = (byte)(nLen >> 16 & 0xFF);
        do_CBW[11] = (byte)(nLen >> 24 & 0xFF);
        ret = this.mEndpointOut != null && this.mConnection != null ? this.mConnection.bulkTransfer(this.mEndpointOut, do_CBW, 31, this.timeOut) : FpCapProcessAPI.jniFpCapProcess_s(this.mEpOutjni, do_CBW, 31, this.timeOut);
        if (ret != 31) {
            Log.e((String)TAG, (String)"1...UDiskDownData DO_CBW fail!\n");
            return -301;
        }
        int nT = 1;
        if (nLen > 32000) {
            nT = 4;
        }
        int j = 0;
        while (j < nT) {
            int blockLen = nLen / nT;
            byte[] temp = Arrays.copyOfRange(pBuf, j * blockLen, (j + 1) * blockLen);
            ret = this.mEndpointOut != null && this.mConnection != null ? this.mConnection.bulkTransfer(this.mEndpointOut, temp, blockLen, this.timeOut) : FpCapProcessAPI.jniFpCapProcess_s(this.mEpOutjni, temp, blockLen, this.timeOut);
            if (ret != blockLen) {
                Log.e((String)TAG, (String)("2...UDiskDownData DI_DATA fail! ret=" + ret));
                return -302;
            }
            ++j;
        }
        ret = this.mEndpointIn != null && this.mConnection != null ? this.mConnection.bulkTransfer(this.mEndpointIn, di_CSW, 13, nTimeOut) : FpCapProcessAPI.jniFpCapProcess_s(this.mEpInjni, di_CSW, 13, nTimeOut);
        if (di_CSW[3] != 83 || di_CSW[12] != 0) {
            Log.e((String)TAG, (String)"3...UDiskDownData DI_CSW fail!\n");
            return -303;
        }
        di_CSW[3] = 67;
        i = 4;
        while (i < 8) {
            if (di_CSW[i] != do_CBW[i]) {
                Log.e((String)TAG, (String)"4...UDiskDownData DI_CSW fail!\n");
                return -303;
            }
            ++i;
        }
        return 0;
    }

    private int UDiskGetData(ByteBuffer img, int nLen) {
        int ret = -1;
        byte[] recvbuffer = new byte[65536];
        byte[] byArray = new byte[32];
        byArray[0] = 85;
        byArray[1] = 83;
        byArray[2] = 66;
        byArray[3] = 67;
        byArray[4] = 83;
        byArray[5] = 121;
        byArray[6] = 110;
        byArray[7] = 111;
        byArray[12] = -128;
        byArray[14] = 10;
        byArray[15] = -123;
        byte[] do_CBW = byArray;
        byte[] di_CSW = new byte[16];
        do_CBW[8] = (byte)(nLen & 0xFF);
        do_CBW[9] = (byte)(nLen >> 8 & 0xFF);
        do_CBW[10] = (byte)(nLen >> 16 & 0xFF);
        do_CBW[11] = (byte)(nLen >> 24 & 0xFF);
        ret = this.mEndpointOut != null && this.mConnection != null ? this.mConnection.bulkTransfer(this.mEndpointOut, do_CBW, 31, this.timeOut) : FpCapProcessAPI.jniFpCapProcess_s(this.mEpOutjni, do_CBW, 31, this.timeOut);
        if (ret != 31) {
            Log.e((String)TAG, (String)"1...UDiskGetData DO_CBW fail!\n");
            return -311;
        }
        int nT = 1;
        if (nLen > 32000) {
            nT = 4;
        }
        int j = 0;
        while (j < nT) {
            int blockLen;
            ret = this.mEndpointIn != null && this.mConnection != null ? this.mConnection.bulkTransfer(this.mEndpointIn, recvbuffer, blockLen, this.timeOut) : FpCapProcessAPI.jniFpCapProcess_s(this.mEpInjni, recvbuffer, blockLen, this.timeOut);
            if (ret != (blockLen = nLen / nT)) {
                Log.e((String)TAG, (String)("2...UDiskGetData DI_DATA fail! ret=" + ret));
                return -312;
            }
            img.put(recvbuffer, 0, blockLen);
            ++j;
        }
        ret = this.mEndpointIn != null && this.mConnection != null ? this.mConnection.bulkTransfer(this.mEndpointIn, di_CSW, 13, this.timeOut) : FpCapProcessAPI.jniFpCapProcess_s(this.mEpInjni, di_CSW, 13, this.timeOut);
        if (di_CSW[3] != 83 || di_CSW[12] != 0) {
            Log.e((String)TAG, (String)"3...UDiskGetData DI_CSW fail!\n");
            return -313;
        }
        int i = 4;
        while (i < 8) {
            if (di_CSW[i] != do_CBW[i]) {
                Log.e((String)TAG, (String)"4...UDiskGetData DI_CSW fail!\n");
                return -313;
            }
            ++i;
        }
        return 0;
    }

    int UDiskVerfiy() {
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        byte[] byArray = new byte[16];
        byArray[0] = -17;
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 1;
        byArray[8] = 7;
        byArray[9] = 19;
        byArray[15] = 27;
        byte[] verfiyCmd = byArray;
        if (this.UDiskDownData(verfiyCmd, verfiyCmd.length) != 0) {
            return -101;
        }
        buffer.clear();
        int ret = this.UDiskGetData(buffer, 64);
        buffer.flip();
        return ret;
    }

    int UdiskDownImage(byte[] buff, int nLen) {
        byte[] byArray = new byte[12];
        byArray[0] = -17;
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 1;
        byArray[8] = 3;
        byArray[9] = 11;
        byArray[11] = 15;
        byte[] downImgCmd = byArray;
        if (this.UDiskDownData(downImgCmd, downImgCmd.length) != 0) {
            return -101;
        }
        int iTmpLen = nLen / 2;
        int ret = this.UDiskDownData(buff, iTmpLen);
        if (ret != 0) {
            return -101;
        }
        ret = this.UDiskDownData(Arrays.copyOfRange(buff, iTmpLen, buff.length), iTmpLen);
        if (ret != 0) {
            return -101;
        }
        return 0;
    }

    int UdiskUpImage(ByteBuffer Buff, int nLen) {
        byte[] byArray = new byte[12];
        byArray[0] = -17;
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 1;
        byArray[8] = 3;
        byArray[9] = 10;
        byArray[11] = 14;
        byte[] upImgCmd = byArray;
        if (this.UDiskDownData(upImgCmd, upImgCmd.length) != 0) {
            return -101;
        }
        Buff.clear();
        int iTmpLen = nLen / 2;
        int ret = this.UDiskGetData(Buff, iTmpLen);
        if (ret != 0) {
            return -101;
        }
        ret = this.UDiskGetData(Buff, iTmpLen);
        if (ret != 0) {
            return -101;
        }
        Buff.flip();
        return ret;
    }

    int UdiskGetImage() {
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        byte[] byArray = new byte[12];
        byArray[0] = -17;
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 1;
        byArray[8] = 3;
        byArray[9] = 1;
        byArray[11] = 5;
        byte[] getImgCmd = byArray;
        if (this.UDiskDownData(getImgCmd, getImgCmd.length) != 0) {
            return -101;
        }
        buffer.clear();
        int ret = this.UDiskGetData(buffer, 64);
        buffer.flip();
        if (ret == 0) {
            byte[] Arr = Arrays.copyOfRange(buffer.array(), 0, 10);
            byte result = Arr[9];
            return result;
        }
        return -101;
    }

    int UdiskGenFPFeature(int iBufferID) {
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        if ((iBufferID & 0xF) < 1 || (iBufferID & 0xF) > 3) {
            iBufferID = 1;
        }
        byte[] byArray = new byte[13];
        byArray[0] = -17;
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 1;
        byArray[8] = 4;
        byArray[9] = 2;
        byArray[10] = (byte)iBufferID;
        byArray[12] = (byte)(iBufferID + 7);
        byte[] genFPfeatCmd = byArray;
        if (this.UDiskDownData(genFPfeatCmd, genFPfeatCmd.length) != 0) {
            return -101;
        }
        buffer.clear();
        int ret = this.UDiskGetData(buffer, 64);
        if (ret != 0) {
            return -101;
        }
        buffer.flip();
        return ret;
    }

    int UdiskUpChar(ByteBuffer pTemplet, int nLen, int iBufferID) {
        if (iBufferID < 1 || iBufferID > 3) {
            iBufferID = 1;
        }
        byte[] byArray = new byte[13];
        byArray[0] = -17;
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 1;
        byArray[8] = 4;
        byArray[9] = 8;
        byArray[10] = (byte)iBufferID;
        byArray[12] = (byte)(13 + iBufferID);
        byte[] upCharCmd = byArray;
        if (this.UDiskDownData(upCharCmd, upCharCmd.length) != 0) {
            return -101;
        }
        pTemplet.clear();
        int iTmpLen = nLen;
        int ret = this.UDiskGetData(pTemplet, iTmpLen);
        if (ret != 0) {
            return -101;
        }
        pTemplet.flip();
        return ret;
    }

    int UdiskDownChar(byte[] FeatBuff, int nLen, int iBufferID) {
        if (iBufferID < 1 || iBufferID > 3) {
            iBufferID = 1;
        }
        byte[] byArray = new byte[13];
        byArray[0] = -17;
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 1;
        byArray[8] = 4;
        byArray[9] = 9;
        byArray[10] = (byte)iBufferID;
        byArray[12] = (byte)(14 + iBufferID);
        byte[] downCharCmd = byArray;
        if (this.UDiskDownData(downCharCmd, downCharCmd.length) != 0) {
            return -101;
        }
        int iTmpLen = nLen;
        int ret = this.UDiskDownData(FeatBuff, iTmpLen);
        if (ret != 0) {
            return -101;
        }
        return 0;
    }

    int UdiskGetCardMessage() {
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        byte[] byArray = new byte[12];
        byArray[0] = -17;
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 1;
        byArray[8] = 3;
        byArray[9] = 30;
        byArray[11] = 34;
        byte[] getCardCmd = byArray;
        int ret = this.UDiskDownData(getCardCmd, getCardCmd.length);
        if (ret != 0) {
            Log.e((String)TAG, (String)("UdiskGetCardMessage UDiskDownData " + ret));
            return -101;
        }
        buffer.clear();
        ret = this.UDiskGetData(buffer, 64);
        buffer.flip();
        if (ret == 0) {
            byte[] Arr = Arrays.copyOfRange(buffer.array(), 0, 10);
            byte result = Arr[9];
            return result;
        }
        return -101;
    }

    int UdiskMatch(int[] result) {
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        byte[] byArray = new byte[12];
        byArray[0] = -17;
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 1;
        byArray[8] = 3;
        byArray[9] = 3;
        byArray[11] = 7;
        byte[] matchCmd = byArray;
        if (this.UDiskDownData(matchCmd, matchCmd.length) != 0) {
            return -101;
        }
        buffer.clear();
        int ret = this.UDiskGetData(buffer, 64);
        buffer.flip();
        if (ret == 0) {
            byte[] Arr = new byte[20];
            Arr = Arrays.copyOfRange(buffer.array(), 0, 20);
            result[0] = (Arr[10] & 0xFF) * 256 + (Arr[11] & 0xFF);
            result[1] = (Arr[12] & 0xFF) * 256 + (Arr[13] & 0xFF);
            Log.d((String)TAG, (String)("result[0]==" + result[0] + "\nresult[1]==" + result[1]));
            if (result.length > 2) {
                result[2] = (Arr[14] & 0xFF) * 256 + (Arr[15] & 0xFF);
                Log.d((String)TAG, (String)("result[2]==" + result[2]));
            }
        }
        return ret;
    }

    int UdiskReadPageInfo(ByteBuffer Buff, int nLen) {
        byte[] byArray = new byte[12];
        byArray[0] = -17;
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 1;
        byArray[8] = 3;
        byArray[9] = 22;
        byArray[11] = 26;
        byte[] getPageCmd = byArray;
        if (this.UDiskDownData(getPageCmd, getPageCmd.length) != 0) {
            return -101;
        }
        Buff.clear();
        int ret = this.UDiskGetData(Buff, nLen);
        if (ret != 0) {
            return -101;
        }
        Buff.flip();
        return ret;
    }

    int UdiskInitFp() {
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        byte[] byArray = new byte[12];
        byArray[0] = -17;
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 1;
        byArray[8] = 3;
        byArray[9] = 50;
        byArray[11] = 54;
        byte[] getPageCmd = byArray;
        if (this.UDiskDownData(getPageCmd, getPageCmd.length, 15000) != 0) {
            return -101;
        }
        buffer.clear();
        int ret = this.UDiskGetData(buffer, 64);
        buffer.flip();
        if (ret == 0) {
            byte[] Arr = Arrays.copyOfRange(buffer.array(), 0, 10);
            byte result = Arr[9];
            return result;
        }
        return -101;
    }

    int UdiskClearModelFlags() {
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        byte[] byArray = new byte[12];
        byArray[0] = -17;
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 1;
        byArray[8] = 3;
        byArray[9] = 51;
        byArray[11] = 55;
        byte[] getPageCmd = byArray;
        if (this.UDiskDownData(getPageCmd, getPageCmd.length) != 0) {
            return -101;
        }
        buffer.clear();
        int ret = this.UDiskGetData(buffer, 64);
        if (ret != 0) {
            return -101;
        }
        buffer.flip();
        return ret;
    }

    boolean CheckConnection(UsbDevice device) {
        boolean ret;
        block3: {
            block4: {
                ret = false;
                if (this.mConnection != null || device == null) break block3;
                this.mConnection = this.GetConnection(device);
                if (this.mConnection != null) break block4;
                return false;
            }
            try {
                this.mConnection.claimInterface(device.getInterface(0), false);
                ret = true;
            }
            catch (SecurityException e) {
                Log.e((String)TAG, (String)"java.lang.SecurityException e: CheckConnection!!!");
            }
        }
        return ret;
    }

    void CloseConnection(UsbDevice device) {
        if (this.mConnection != null && device != null) {
            this.mConnection.releaseInterface(device.getInterface(0));
            this.mConnection.close();
            this.mConnection = null;
        }
    }
}

