/*
 * Decompiled with CFR 0.152.
 */
package com.hisign.AS60xSDK;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.util.Log;
import com.hisign.AS60xSDK.AS60xDatas;
import com.hisign.AS60xSDK.FpCapProcessAPI;
import com.hisign.AS60xSDK.FpQualityEmbedAPI;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

@TargetApi(value=12)
public class AS60xIO {
    private static final String TAG = "AS60xIO";
    private static final AS60xDatas as60xDatas = new AS60xDatas();
    private static boolean JNI_isdeviceInit = false;

    public static UsbDevice FCV_OpenDevice(Context mContext, int VendorId, int ProductId) {
        UsbDevice mdevice = null;
        mdevice = as60xDatas.OpenAS60xDevice(mContext, VendorId, ProductId);
        byte[] dataPtr = new byte[]{(byte)(VendorId & 0xFF), (byte)(VendorId >> 8 & 0xFF), (byte)(ProductId & 0xFF), (byte)(ProductId >> 8 & 0xFF)};
        int nRet = FpCapProcessAPI.jniFpCapProcess_s(0, dataPtr, 0, 0);
        if (nRet != -1 && nRet != -101) {
            JNI_isdeviceInit = true;
        }
        return mdevice;
    }

    public static UsbDevice FCV_OpenDeviceEx(Context mContext, int VendorId, int ProductId, int mEpOut, int mEpIn) {
        UsbDevice mdevice = null;
        if (-1 == mEpIn && -1 == mEpOut) {
            Log.d((String)TAG, (String)"Java Inited....");
            mdevice = as60xDatas.OpenAS60xDevice(mContext, VendorId, ProductId);
        } else {
            Log.d((String)TAG, (String)"JNI Inited....");
            as60xDatas.tranSmitEndPointParamsJni(mEpOut, mEpIn);
            byte[] dataPtr = new byte[]{(byte)(VendorId & 0xFF), (byte)(VendorId >> 8 & 0xFF), (byte)(ProductId & 0xFF), (byte)(ProductId >> 8 & 0xFF)};
            int nRet = FpCapProcessAPI.jniFpCapProcess_s(0, dataPtr, 0, 0);
            if (nRet != -1 && nRet != -101) {
                JNI_isdeviceInit = true;
            }
        }
        return mdevice;
    }

    public static void FCV_CloseDevice(UsbDevice device) {
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected) {
            as60xDatas.CloseConnection(device);
            device = null;
        }
        if (JNI_isdeviceInit) {
            FpCapProcessAPI.jniFpCapProcess_s(-1, null, 0, 0);
            JNI_isdeviceInit = false;
        }
    }

    public static int FCV_GenImg(UsbDevice device) {
        int nRet = -1;
        nRet = AS60xIO.HS_GetImage(device, 0);
        if (nRet == 0) {
            nRet = AS60xIO.HS_GenChar(device, 0, 1);
        }
        return nRet;
    }

    public static int FCV_ReadIDCard(UsbDevice device, byte[] dataBuf, int[] isFPfeat, boolean isCryptoed) {
        isCryptoed = false;
        int nRet = -1;
        if (isFPfeat.length < 1 || dataBuf.length < 1296) {
            nRet = -2;
            Log.e((String)TAG, (String)("HS_UpChar ArrayIndexOutOfBoundsException\uff1a nRet=" + nRet));
        } else {
            int[] iImageLength;
            byte[] cardMsgArr;
            isFPfeat[0] = nRet = AS60xIO.HS_GetCardMessage(device, 0);
            if (!(nRet != 0 && nRet != 24 && nRet != 25 || (nRet = AS60xIO.HS_UpImage(device, 0, cardMsgArr = new byte[92160], iImageLength = new int[2])) != 0 || isCryptoed)) {
                System.arraycopy(cardMsgArr, 0, dataBuf, 0, 1296);
            }
        }
        return nRet;
    }

    public static int FCV_Match(UsbDevice device, int[] score) {
        int nRet = -1;
        nRet = AS60xIO.HS_Match(device, 0, score);
        return nRet;
    }

    public static int FCV_GetQualityScore(byte[] FingerImgBuf, byte[] nScore) {
        int nRet = -1;
        nRet = FpQualityEmbedAPI.GetQualityScore_s(FingerImgBuf, nScore);
        return nRet;
    }

    public static int FCV_GetQualityScoreEx(byte[] FingerImgBuf, byte[] nScore, byte[] nResult) {
        int nRet = -1;
        nRet = FpQualityEmbedAPI.GetQualityScoreEx_s(FingerImgBuf, nScore, nResult);
        return nRet;
    }

    private static void CompressByte(byte[] source, byte[] dest, int offset) {
        int temp = 0;
        int j = 0;
        while (j < 92160) {
            temp = 0;
            int i = 0;
            while (i < 8) {
                temp <<= 1;
                if (source[i + j] == 0) {
                    ++temp;
                }
                ++i;
            }
            dest[offset + j / 8] = (byte)temp;
            j += 8;
        }
        System.arraycopy(source, 92160, dest, offset + 11520, 512);
    }

    public static int FCV_GenCharWithQA(UsbDevice device, int nAddr, int iBufferID, byte[] FingerImgBuf, byte[] nQaScore) {
        int nRet = -1;
        byte[] tmpResult = new byte[184320];
        nRet = AS60xIO.FCV_GetQualityScoreEx(FingerImgBuf, nQaScore, tmpResult);
        if (nRet >= 0) {
            byte[] changeRaw = new byte[92160];
            AS60xIO.CompressByte(tmpResult, changeRaw, 0);
            AS60xIO.HS_DownImage(device, nAddr, changeRaw, changeRaw.length);
            AS60xIO.HS_GenChar(device, nAddr, iBufferID + 16);
        }
        return nRet;
    }

    public static String FCV_getSerialNumber(UsbDevice device) {
        int nRet = -1;
        byte[] dataBufAll = new byte[152];
        byte[] dataBuf = new byte[24];
        String serialNo = "";
        nRet = AS60xIO.HS_GetPageInfo(device, 0, dataBufAll);
        System.arraycopy(dataBufAll, 128, dataBuf, 0, 24);
        if (nRet == 0) {
            try {
                serialNo = new String(dataBuf, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return serialNo;
    }

    public static int HS_Verfiy(UsbDevice device) {
        int nRet = -1;
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected || JNI_isdeviceInit) {
            nRet = as60xDatas.UDiskVerfiy();
            as60xDatas.CloseConnection(device);
        }
        return nRet;
    }

    public static int debugSendData() {
        Log.e((String)TAG, (String)"enter debugSendData");
        as60xDatas.UDiskVerfiy();
        Log.e((String)TAG, (String)"leave debugSendData");
        return 0;
    }

    public static int HS_GenChar(UsbDevice device, int nAddr, int iBufferID) {
        int nRet = -1;
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected || JNI_isdeviceInit) {
            nRet = as60xDatas.UdiskGenFPFeature(iBufferID);
            as60xDatas.CloseConnection(device);
        }
        return nRet;
    }

    public static int HS_UpChar(UsbDevice device, int nAddr, int iBufferID, byte[] pTemplet, int[] iTempletLength) {
        int nRet = -1;
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected || JNI_isdeviceInit) {
            if (iTempletLength.length < 1 || pTemplet.length < 512) {
                nRet = -2;
                Log.e((String)TAG, (String)("HS_UpChar ArrayIndexOutOfBoundsException\uff1a nRet=" + nRet));
            } else {
                ByteBuffer Buffer2 = ByteBuffer.allocate(512);
                nRet = as60xDatas.UdiskUpChar(Buffer2, 512, iBufferID);
                if (nRet == 0) {
                    iTempletLength[0] = 512;
                    System.arraycopy(Buffer2.array(), 0, pTemplet, 0, 512);
                } else {
                    iTempletLength[0] = 0;
                    Log.e((String)TAG, (String)("UdiskUpChar error\uff1a nRet=" + nRet));
                }
                Buffer2.clear();
            }
            as60xDatas.CloseConnection(device);
        } else {
            nRet = -3;
            Log.e((String)TAG, (String)("HS_UpChar as60xDatas.CheckConnection error\uff1a nRet=" + nRet));
        }
        return nRet;
    }

    public static int HS_DownChar(UsbDevice device, int nAddr, int iBufferID, byte[] pTemplet, int iTempletLength) {
        int nRet = -1;
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected || JNI_isdeviceInit) {
            nRet = as60xDatas.UdiskDownChar(pTemplet, iTempletLength, iBufferID);
            as60xDatas.CloseConnection(device);
        } else {
            nRet = -3;
            Log.e((String)TAG, (String)("HS_DownChar as60xDatas.CheckConnection error\uff1a nRet=" + nRet));
        }
        return nRet;
    }

    public static int HS_GetImage(UsbDevice device, int nAddr) {
        int nRet = -1;
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected || JNI_isdeviceInit) {
            nRet = as60xDatas.UdiskGetImage();
            as60xDatas.CloseConnection(device);
        }
        return nRet;
    }

    public static int HS_UpImage(UsbDevice device, int nAddr, byte[] pImageData, int[] iImageLength) {
        int nRet = -1;
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected || JNI_isdeviceInit) {
            if (iImageLength.length < 1 || pImageData.length < 92160) {
                nRet = -2;
                Log.e((String)TAG, (String)"ArrayIndexOutOfBoundsException\uff1a nRet = -2");
            } else {
                ByteBuffer Buffer2 = ByteBuffer.allocate(92160);
                nRet = as60xDatas.UdiskUpImage(Buffer2, 92160);
                if (nRet == 0) {
                    iImageLength[0] = 92160;
                    System.arraycopy(Buffer2.array(), 0, pImageData, 0, 92160);
                } else {
                    iImageLength[0] = 0;
                    Log.e((String)TAG, (String)("UdiskUpImage error\uff1a nRet=" + nRet));
                }
                Buffer2.clear();
            }
            as60xDatas.CloseConnection(device);
        } else {
            nRet = -3;
            Log.e((String)TAG, (String)("as60xDatas.CheckConnection error\uff1a nRet=" + nRet));
        }
        return nRet;
    }

    public static int HS_DownImage(UsbDevice device, int nAddr, byte[] pImageData, int iLength) {
        int nRet = -1;
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected || JNI_isdeviceInit) {
            nRet = as60xDatas.UdiskDownImage(pImageData, iLength);
            as60xDatas.CloseConnection(device);
        }
        return nRet;
    }

    public static int HS_GetCardMessage(UsbDevice device, int nAddr) {
        int nRet = -1;
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected || JNI_isdeviceInit) {
            nRet = as60xDatas.UdiskGetCardMessage();
            as60xDatas.CloseConnection(device);
        }
        return nRet;
    }

    public static int HS_Match(UsbDevice device, int nAddr, int[] iScore) {
        int nRet = -1;
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected || JNI_isdeviceInit) {
            if (iScore.length < 2) {
                nRet = -2;
                Log.e((String)TAG, (String)("HS_Match iScore.length<2 nRet=" + nRet));
            } else {
                nRet = as60xDatas.UdiskMatch(iScore);
                as60xDatas.CloseConnection(device);
            }
        }
        return nRet;
    }

    public static int HS_InitFp(UsbDevice device, int nAddr) {
        int nRet = -1;
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected || JNI_isdeviceInit) {
            nRet = as60xDatas.UdiskInitFp();
            as60xDatas.CloseConnection(device);
        }
        return nRet;
    }

    public static int HS_ClearModelFalgs(UsbDevice device, int nAddr) {
        int nRet = -1;
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected || JNI_isdeviceInit) {
            nRet = as60xDatas.UdiskClearModelFlags();
            as60xDatas.CloseConnection(device);
        }
        return nRet;
    }

    public static int HS_GetPageInfo(UsbDevice device, int nAddr, byte[] dataBuf) {
        int nRet = -1;
        boolean isConnected = false;
        isConnected = as60xDatas.CheckConnection(device);
        if (isConnected || JNI_isdeviceInit) {
            ByteBuffer PageBuffer = ByteBuffer.allocate(1024);
            nRet = as60xDatas.UdiskReadPageInfo(PageBuffer, 512);
            if (nRet == 0) {
                System.arraycopy(PageBuffer.array(), 0, dataBuf, 0, dataBuf.length);
                PageBuffer.clear();
            } else {
                Log.e((String)TAG, (String)"HS_GetPageInfo is Error\uff01\uff01\uff01");
            }
            as60xDatas.CloseConnection(device);
        }
        return nRet;
    }

    public static int HS_DownFacefeat(UsbDevice device, int nAddr, byte[][] faceFeat) {
        int nRet = -1;
        long length = 0L;
        byte[] feat = new byte[92160];
        int i = 0;
        while (i < faceFeat.length) {
            if ((length += (long)faceFeat[i].length) >= 41984L) {
                nRet = -2;
                break;
            }
            System.arraycopy(faceFeat[i], 0, feat, 50176 + i * faceFeat[i].length, faceFeat[i].length);
            nRet = 0;
            ++i;
        }
        if (nRet == 0) {
            nRet = AS60xIO.HS_DownImage(device, nAddr, feat, 92160);
        }
        return nRet;
    }

    public static int FCV_FaceMatch(UsbDevice device, int nAddr, byte[][] faceFeat, int[] iScore) {
        int nRet = -1;
        nRet = AS60xIO.HS_DownFacefeat(device, nAddr, faceFeat);
        if (nRet == 0) {
            nRet = AS60xIO.HS_Match(device, nAddr, iScore);
        }
        return nRet;
    }
}

